% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{gisco_nuts_2024}
\alias{gisco_nuts_2024}
\title{NUTS 2024 \code{\link[sf:sf]{sf}} object}
\format{
A \code{\link[sf:sf]{sf}} object with \code{MULTIPOLYGON} geometries, resolution:
1:20 million and \href{https://epsg.io/4326}{EPSG:4326}. with
1798 rows and 10 variables:
\describe{
\item{\code{NUTS_ID}}{NUTS identifier.}
\item{\code{LEVL_CODE}}{NUTS level code \verb{(0,1,2,3)}.}
\item{\code{CNTR_CODE}}{Eurostat Country code.}
\item{\code{NAME_LATN}}{NUTS name on Latin characters.}
\item{\code{NUTS_NAME}}{NUTS name on local alphabet.}
\item{\code{MOUNT_TYPE}}{Mount Type, see \strong{Details}.}
\item{\code{URBN_TYPE}}{Urban Type, see \strong{Details}.}
\item{\code{COAST_TYPE}}{Coast Type, see \strong{Details}.}
\item{\code{geo}}{Same as \code{NUTS_ID}, provided for compatibility with
\CRANpkg{eurostat}.}
\item{\code{geometry}}{geometry field.}
}
}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/nuts/gpkg/}{NUTS_RG_20M_2024_4326.gpkg} file.
}
\description{
This dataset represents the regions for levels 0, 1, 2 and 3 of the
Nomenclature of Territorial Units for Statistics (NUTS) for 2024.
}
\details{
\code{MOUNT_TYPE}: Mountain typology:
\itemize{
\item \code{1}: More than 50 \% of the surface is covered by topographic mountain
areas.
\item \code{2}: More than 50 \% of the regional population lives in topographic
mountain areas.
\item \code{3}: More than 50 \% of the surface is covered by topographic mountain
areas and where more than 50 \% of the regional population lives in these
mountain areas.
\item \code{4}: Non-mountain region / other regions.
\item \code{0}: No classification provided.
}

\code{URBN_TYPE}: Urban-rural typology:
\itemize{
\item \code{1}: Predominantly urban region.
\item \code{2}: Intermediate region.
\item \code{3}: Predominantly rural region.
\item \code{0}: No classification provided.
}

\code{COAST_TYPE}: Coastal typology:
\itemize{
\item \code{1}: Coastal (on coast).
\item \code{2}: Coastal (less than 50\% of population living within 50 km. of the
coastline).
\item \code{3}: Non-coastal region.
\item \code{0}: No classification provided.
}
}
\examples{
data("gisco_nuts_2024")
head(gisco_nuts_2024)

}
\seealso{
\code{\link[=gisco_get_nuts]{gisco_get_nuts()}}

Other datasets: 
\code{\link{gisco_coastal_lines}},
\code{\link{gisco_countries_2024}},
\code{\link{gisco_countrycode}},
\code{\link{gisco_db}}
}
\concept{datasets}
