% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{gisco_db}
\alias{gisco_db}
\title{Cached GISCO database}
\format{
A \link[tibble:tbl_df-class]{tibble} with
9,714 rows.
}
\source{
GISCO API \code{datasets.json}.
}
\description{
Database with the list of files in the GISCO API as of
2026-01-12.
}
\details{
This database is used to redirect the corresponding functions to the
right API endpoints.

This version of the database would be used in case there is any problem on
update. Please use \code{\link[=gisco_get_cached_db]{gisco_get_cached_db()}} with \code{update_cache = TRUE} to
update the corresponding API endpoints.
}
\examples{
data("gisco_db")
gisco_db |>
  dplyr::glimpse()
}
\seealso{
Other datasets: 
\code{\link{gisco_coastal_lines}},
\code{\link{gisco_countries_2024}},
\code{\link{gisco_countrycode}},
\code{\link{gisco_nuts_2024}}

Other database utils:
\code{\link{gisco_get_cached_db}()},
\code{\link{gisco_get_metadata}()}
}
\concept{database}
\concept{datasets}
