% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_ordiplot.R
\name{gg_ordiplot}
\alias{gg_ordiplot}
\title{Plot with Ellipses, Hulls, Spiders}
\usage{
gg_ordiplot(
  ord,
  groups,
  scaling = 1,
  choices = c(1, 2),
  kind = c("sd", "se", "ehull"),
  conf = NULL,
  show.groups = "all",
  ellipse = TRUE,
  label = FALSE,
  hull = FALSE,
  spiders = FALSE,
  pt.size = 3,
  plot = TRUE
)
}
\arguments{
\item{ord}{An ordination object.}

\item{groups}{A vector of groups.}

\item{scaling}{Scaling for ordination plot.}

\item{choices}{Axes to be plotted.}

\item{kind}{Type of ellipses to show ("se", sd", "ehull").}

\item{conf}{Confidence value for ellipses if "se" or "sd."}

\item{show.groups}{Subset of groups to plot.}

\item{ellipse}{A logical for plotting ellipses; defaults to TRUE.}

\item{label}{A logical for labeling group centroids.}

\item{hull}{A logical for plotting group hulls.}

\item{spiders}{A logical for plotting group spiders.}

\item{pt.size}{Symbol size.}

\item{plot}{A logical for plotting; defaults to TRUE.}
}
\value{
Silently returns the plot and data frames used for the plotting.
}
\description{
\code{gg_ordiplot} uses \code{ggplot2} to make an ordination plot
with group ellipses by default, and optionally hulls and/or
spiders. It is patterned after \code{vegan}'s functions \code{ordiellipse},
\code{ordihull}, and \code{ordispider} and accepts similar parameters.
}
\examples{
data("dune")
data("dune.env")
dune.hel <- decostand(dune, method = "hellinger")
ord <- rda(dune.hel)
gg_ordiplot(ord, groups = dune.env$Management)

}
