% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_position.R
\name{legend_top}
\alias{legend_top}
\title{Place Legend on Top with Horizontal Layout}
\usage{
legend_top(align_to = c("panel", "plot"), by = NULL)
}
\arguments{
\item{align_to}{Where to align the legend. Either \code{"panel"} (default,
aligns to plot panel) or \code{"plot"} (aligns to full plot including title).
Requires ggplot2 >= 3.5.0 for \code{"plot"} alignment. Ignored when
\code{by} is specified.}

\item{by}{Optional aesthetic name (character) to position only a specific
legend. When specified, uses per-guide positioning via
\code{guide_legend(position = "top")}. Requires ggplot2 >= 3.5.0.
Common values: \code{"colour"}, \code{"fill"}, \code{"size"}.}
}
\value{
A ggplot2 theme object (when \code{by} is NULL) or a guides
specification (when \code{by} is specified).
}
\description{
A one-liner to position the legend above the plot with horizontal layout.
Optionally aligns to the full plot area (including title) rather than just
the panel.
}
\examples{
library(ggplot2)

# Basic usage - aligned to panel
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_top()

# Aligned to full plot (useful with titles)
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  labs(title = "My Plot Title") +
  legend_top(align_to = "plot")

# Position only the colour legend on top
ggplot(mtcars, aes(mpg, wt, color = factor(cyl), size = hp)) +
  geom_point() +
  legend_top(by = "colour") +
  legend_right(by = "size")

}
\seealso{
\code{\link{legend_bottom}}, \code{\link{legend_left}},
\code{\link{legend_right}}, \code{\link{legend_horizontal}}
}
