% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend_position.R
\name{legend_horizontal}
\alias{legend_horizontal}
\title{Set Legend Direction to Horizontal}
\usage{
legend_horizontal()
}
\value{
A ggplot2 theme object that can be added to a plot.
}
\description{
A one-liner to arrange legend keys horizontally. Useful for legends placed
at the top or bottom of a plot.
}
\examples{
library(ggplot2)

# Horizontal legend at bottom
ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  legend_bottom() +
  legend_horizontal()

}
\seealso{
\code{\link{legend_vertical}}, \code{\link{legend_top}},
\code{\link{legend_bottom}}
}
