% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcorrplot.R
\name{ggcorrplot}
\alias{ggcorrplot}
\alias{cor_pmat}
\title{Visualization of a correlation matrix using ggplot2}
\usage{
ggcorrplot(
  corr,
  method = c("square", "circle"),
  type = c("full", "lower", "upper"),
  ggtheme = ggplot2::theme_minimal,
  title = "",
  show.legend = TRUE,
  legend.title = "Corr",
  show.diag = NULL,
  colors = c("blue", "white", "red"),
  outline.color = "gray",
  hc.order = FALSE,
  hc.method = "complete",
  lab = FALSE,
  lab_col = "black",
  lab_size = 4,
  p.mat = NULL,
  sig.level = 0.05,
  insig = c("pch", "blank"),
  pch = 4,
  pch.col = "black",
  pch.cex = 5,
  tl.cex = 12,
  tl.col = "black",
  tl.srt = 45,
  digits = 2,
  as.is = FALSE
)

cor_pmat(x, ...)
}
\arguments{
\item{corr}{the correlation matrix to visualize}

\item{method}{character, the visualization method of correlation matrix to be
used. Allowed values are "square" (default), "circle".}

\item{type}{character, "full" (default), "lower" or "upper" display.}

\item{ggtheme}{ggplot2 function or theme object. Default value is
`theme_minimal`. Allowed values are the official ggplot2 themes including
theme_gray, theme_bw, theme_minimal, theme_classic, theme_void, .... Theme
objects are also allowed (e.g., `theme_classic()`).}

\item{title}{character, title of the graph.}

\item{show.legend}{logical, if TRUE the legend is displayed.}

\item{legend.title}{a character string for the legend title. lower
triangular, upper triangular or full matrix.}

\item{show.diag}{NULL or logical, whether display the correlation
coefficients on the principal diagonal. If \code{NULL}, the default is to
show diagonal correlation for \code{type = "full"} and to remove it when
\code{type} is one of "upper" or "lower".}

\item{colors}{a vector of 3 colors for low, mid and high correlation values.}

\item{outline.color}{the outline color of square or circle. Default value is
"gray".}

\item{hc.order}{logical value. If TRUE, correlation matrix will be hc.ordered
using hclust function.}

\item{hc.method}{the agglomeration method to be used in hclust (see ?hclust).}

\item{lab}{logical value. If TRUE, add correlation coefficient on the plot.}

\item{lab_col, lab_size}{size and color to be used for the correlation
coefficient labels. used when lab = TRUE.}

\item{p.mat}{matrix of p-value. If NULL, arguments sig.level, insig, pch,
pch.col, pch.cex is invalid.}

\item{sig.level}{significant level, if the p-value in p-mat is bigger than
sig.level, then the corresponding correlation coefficient is regarded as
insignificant.}

\item{insig}{character, specialized insignificant correlation coefficients,
"pch" (default), "blank". If "blank", wipe away the corresponding glyphs;
if "pch", add characters (see pch for details) on corresponding glyphs.}

\item{pch}{add character on the glyphs of insignificant correlation
coefficients (only valid when insig is "pch"). Default value is 4.}

\item{pch.col, pch.cex}{the color and the cex (size) of pch (only valid when
insig is "pch").}

\item{tl.cex, tl.col, tl.srt}{the size, the color and the string rotation of
text label (variable names).}

\item{digits}{Decides the number of decimal digits to be displayed (Default:
`2`).}

\item{as.is}{A logical passed to \code{\link[reshape2]{melt.array}}. If
\code{TRUE}, dimnames will be left as strings instead of being converted
using \code{\link[utils]{type.convert}}.}

\item{x}{numeric matrix or data frame}

\item{...}{other arguments to be passed to the function cor.test.}
}
\value{
\itemize{ \item ggcorrplot(): Returns a ggplot2 \item cor_pmat():
Returns a matrix containing the p-values of correlations }
}
\description{
\itemize{ \item ggcorrplot(): A graphical display of a
  correlation matrix using ggplot2. \item cor_pmat(): Compute a correlation
  matrix p-values. }
}
\examples{
# Compute a correlation matrix
data(mtcars)
corr <- round(cor(mtcars), 1)
corr

# Compute a matrix of correlation p-values
p.mat <- cor_pmat(mtcars)
p.mat

# Visualize the correlation matrix
# --------------------------------
# method = "square" or "circle"
ggcorrplot(corr)
ggcorrplot(corr, method = "circle")

# Reordering the correlation matrix
# --------------------------------
# using hierarchical clustering
ggcorrplot(corr, hc.order = TRUE, outline.color = "white")

# Types of correlogram layout
# --------------------------------
# Get the lower triangle
ggcorrplot(corr,
  hc.order = TRUE, type = "lower",
  outline.color = "white"
)
# Get the upeper triangle
ggcorrplot(corr,
  hc.order = TRUE, type = "upper",
  outline.color = "white"
)

# Change colors and theme
# --------------------------------
# Argument colors
ggcorrplot(corr,
  hc.order = TRUE, type = "lower",
  outline.color = "white",
  ggtheme = ggplot2::theme_gray,
  colors = c("#6D9EC1", "white", "#E46726")
)

# Add correlation coefficients
# --------------------------------
# argument lab = TRUE
ggcorrplot(corr,
  hc.order = TRUE, type = "lower",
  lab = TRUE,
  ggtheme = ggplot2::theme_dark(),
)

# Add correlation significance level
# --------------------------------
# Argument p.mat
# Barring the no significant coefficient
ggcorrplot(corr,
  hc.order = TRUE,
  type = "lower", p.mat = p.mat
)
# Leave blank on no significant coefficient
ggcorrplot(corr,
  p.mat = p.mat, hc.order = TRUE,
  type = "lower", insig = "blank"
)

# Changing number of digits for correlation coeffcient
# --------------------------------
ggcorrplot(cor(mtcars),
  type = "lower",
  insig = "blank",
  lab = TRUE,
  digits = 3
)
}
