% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.galamm.R
\name{predict.galamm}
\alias{predict.galamm}
\title{Predictions from a model at new data values}
\usage{
\method{predict}{galamm}(object, newdata = NULL, type = c("link", "response", "lpmatrix"), ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{newdata}{Data from for which to evaluate predictions, in a
\code{data.frame}. Defaults to "NULL", which means that the predictions are
evaluate at the data used to fit the model.}

\item{type}{Character argument specifying the type of prediction object to be
returned. Case sensitive.}

\item{...}{Optional arguments passed on to other methods. Currently used for
models with smooth terms, for which these arguments are forwarded to
\code{mgcv::predict.gam}.}
}
\value{
A numeric vector of predicted values.
}
\description{
Predictions are given at the population level, i.e., with random
effects set to zero. For fitted models including random effects, see
\code{\link{fitted.galamm}}. For mixed response models, only predictions on
the scale of the linear predictors is supported.
}
\examples{
# Poisson GLMM
count_mod <- galamm(
  formula = y ~ lbas * treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

# Plot response versus link:
plot(
  predict(count_mod, type = "link"),
  predict(count_mod, type = "response")
)

# Predict on a new dataset
nd <- data.frame(lbas = c(.3, .2), treat = c(0, 1), lage = 0.2, v4 = -.2)
predict(count_mod, newdata = nd)
predict(count_mod, newdata = nd, type = "response")

# Semiparametric model
dat <- subset(cognition, domain == 1 & item == "11")
dat$y <- dat$y[, 1]
mod <- galamm(y ~ s(x) + (1 | id), data = dat)

# Get the linear predictor matrix
Xp <- predict(mod, type = "lpmatrix")
# Compute the estimated smooth function
# See the vignette on posterior sampling for details
betas <- coef(mod$gam)
fit <- Xp \%*\% betas
plot(dat$x, fit)

}
\seealso{
\code{\link[=fitted.galamm]{fitted.galamm()}} for model fits, \code{\link[=residuals.galamm]{residuals.galamm()}} for
residuals, and \code{\link[=predict]{predict()}} for the generic function.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{appraise.galamm}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{derivatives.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{model.frame.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
