% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g.ridge.R
\name{g.ridge}
\alias{g.ridge}
\title{g.ridge (generalized ridge regression)}
\usage{
g.ridge(X, Y, method = "HK", kmax = 500)
}
\arguments{
\item{X}{design matrix of explanatory variables (regressors)}

\item{Y}{vector of response variables}

\item{method}{"HK" or "YE" for Hoerl and Kennard (1970) or Yang and Emura (2017)}

\item{kmax}{maximum possible value for the shrinkage parameter (the "lambda" parameter),
where the parameter is optimized in the interval (0, kmax).}
}
\value{
lambda: optimized shrinkage parameter

delta: the optimized thresholding parameter

estimate: regression coefficients (beta)

SE: Standard Error

Z: Z-value for testing beta=0

SE: P-value for testing beta=0

Sigma: variance estimate of the error distribution
 (the square of the standard deviation)

delta: thresholding parameter
}
\description{
Generalized ridge regression with the optimal shrinkage parameter.
 Ridge regression (Hoerl and Kennard, 1970) and
 generalized ridge regression (Yang and Emura 2017) are implemented.
 Tuning parameters are optimized by minimizing the CGV function (by the function CGV(.)):
  See Golub et al. (1979), and Sections 2.3 and 3.3 of Yang and Emura (2017).
}
\examples{
n=100 # no. of observations
p=100 # no. of dimensions
q=r=10 # no. of nonzero coefficients
beta=c(rep(0.5,q),rep(0.5,r),rep(0,p-q-r))
X=X.mat(n,p,q,r)
Y=X\%*\%beta+rnorm(n,0,1)
g.ridge(X,Y-mean(Y),method="HK",kmax=200)
g.ridge(X,Y-mean(Y),method="YE",kmax=200)
}
\references{
Yang SP, Emura T (2017) A Bayesian approach with generalized ridge estimation
 for high-dimensional regression and testing, Commun Stat-Simul 46(8): 6083-105.

Hoerl AE, Kennard RW (1970) Ridge regression: Biased estimation for
 nonorthogonal problems. Technometrics 12:55–67.
}
