# lme4::allFit(...) =>
#
# local({
#   cl <- future::makeClusterFuture(<future arguments>)
#   lme4::allFit(..., parallel = "snow", ncpus = 2L, cl = cl)
# })
#
append_transpilers_for_lme4 <- function() {
  package <- "lme4"

  if (getRversion() < "4.4.0") {
    stop(sprintf("You are running R %s, but futurization of '%s' functions requires R (>= 4.4.0)", getRversion(), package))
  }

  template <- quote(
    local({
      cl <- do.call(CALL, args = OPTS)
      oopts <- options(future.ClusterFuture.clusterEvalQ = "error")
      on.exit(options(oopts))
      EXPR
    })
  )

  idx_CALL <- c(2, 2, 3, 2)
  idx_OPTS <- c(2, 2, 3, 3)
  idx_EXPR <- c(2, 5)

  ## SPECIAL CASE: Are we running under 'covr'?
  if (length(template[[idx_CALL]]) > 1) {
    idx_CALL <- c(2, 2, 3, 3, 3, 2)
    idx_OPTS <- c(2, 2, 3, 3, 3, 3)
    idx_EXPR <- c(2, 5, 3, 3)
  }

  ## To please 'R CMD check' on R (< 4.4.0), where
  ## future::makeClusterFuture() is not available
  
  call <- as.call(lapply(c("::", "future", "makeClusterFuture"), as.name))
  template[[idx_CALL]] <- call

  make_transpiler <- function(name) {
    defaults <- list()
    if (name == "allFit") {
      defaults <- list(packages = "lme4")
    }
    

    transpiler <- eval(bquote(function(expr, options = NULL) {
      ## Update 'OPTS'
      template[[idx_OPTS]] <- make_options_for_doFuture(options, defaults = .(defaults), wrap = FALSE)
  
      ## Update 'EXPR'
      parts <- c(
        as.list(expr),
        parallel = "snow",
        ncpus = 2L,   ## only used for test ncpus > 1
        cl = quote(cl)
      )
      template[[idx_EXPR]] <- as.call(parts)
      
      template
    }))
    body(transpiler) <- body(transpiler)
    
    transpiler
  }

  transpilers <- list()

  ns <- getNamespace(package)
  exports <- names(ns[[".__NAMESPACE__."]][["exports"]])
  names <- exports
  for (name in names) {
    if (exists(name, mode = "function", envir = ns, inherits = FALSE)) {
      fcn <- get(name, mode = "function", envir = ns, inherits = FALSE)
      if ("parallel" %in% names(formals(fcn))) {
        transpilers[[name]] <- list(
          label = sprintf("%s::%s() ~> %s::%s(..., parallel = TRUE)", package, name, package, name),
          transpiler = make_transpiler(name)
        )
      }
    }
  }

  transpilers <- list(transpilers)
  names(transpilers) <- package

  append_transpilers("futurize::add-on", transpilers)

  ## Return required packages
  c(package, "future")
}
