% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concept_lattice.R
\name{ConceptLattice}
\alias{ConceptLattice}
\title{R6 class for a concept lattice}
\description{
This class implements the data structure and methods for concept lattices.
}
\examples{
# Build a formal context
fc_planets <- FormalContext$new(planets)

# Find the concepts
fc_planets$find_concepts()

# Find join- and meet- irreducible elements
fc_planets$concepts$join_irreducibles()
fc_planets$concepts$meet_irreducibles()

# Get concept support
fc_planets$concepts$support()


## ------------------------------------------------
## Method `ConceptLattice$top`
## ------------------------------------------------

fc <- FormalContext$new(planets)
fc$find_concepts()
fc$concepts$top()


## ------------------------------------------------
## Method `ConceptLattice$bottom`
## ------------------------------------------------

fc <- FormalContext$new(planets)
fc$find_concepts()
fc$concepts$bottom()

}
\section{Super class}{
\code{\link[fcaR:ConceptSet]{fcaR::ConceptSet}} -> \code{ConceptLattice}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConceptLattice-new}{\code{ConceptLattice$new()}}
\item \href{#method-ConceptLattice-plot}{\code{ConceptLattice$plot()}}
\item \href{#method-ConceptLattice-sublattice}{\code{ConceptLattice$sublattice()}}
\item \href{#method-ConceptLattice-top}{\code{ConceptLattice$top()}}
\item \href{#method-ConceptLattice-bottom}{\code{ConceptLattice$bottom()}}
\item \href{#method-ConceptLattice-join_irreducibles}{\code{ConceptLattice$join_irreducibles()}}
\item \href{#method-ConceptLattice-meet_irreducibles}{\code{ConceptLattice$meet_irreducibles()}}
\item \href{#method-ConceptLattice-decompose}{\code{ConceptLattice$decompose()}}
\item \href{#method-ConceptLattice-supremum}{\code{ConceptLattice$supremum()}}
\item \href{#method-ConceptLattice-infimum}{\code{ConceptLattice$infimum()}}
\item \href{#method-ConceptLattice-subconcepts}{\code{ConceptLattice$subconcepts()}}
\item \href{#method-ConceptLattice-superconcepts}{\code{ConceptLattice$superconcepts()}}
\item \href{#method-ConceptLattice-lower_neighbours}{\code{ConceptLattice$lower_neighbours()}}
\item \href{#method-ConceptLattice-upper_neighbours}{\code{ConceptLattice$upper_neighbours()}}
\item \href{#method-ConceptLattice-stability}{\code{ConceptLattice$stability()}}
\item \href{#method-ConceptLattice-separation}{\code{ConceptLattice$separation()}}
\item \href{#method-ConceptLattice-density}{\code{ConceptLattice$density()}}
\item \href{#method-ConceptLattice-is_distributive}{\code{ConceptLattice$is_distributive()}}
\item \href{#method-ConceptLattice-is_modular}{\code{ConceptLattice$is_modular()}}
\item \href{#method-ConceptLattice-is_semimodular}{\code{ConceptLattice$is_semimodular()}}
\item \href{#method-ConceptLattice-is_atomic}{\code{ConceptLattice$is_atomic()}}
\item \href{#method-ConceptLattice-clone}{\code{ConceptLattice$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="["><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-bracket'><code>fcaR::ConceptSet$[()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="extents"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-extents'><code>fcaR::ConceptSet$extents()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="intents"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-intents'><code>fcaR::ConceptSet$intents()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="is_empty"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-is_empty'><code>fcaR::ConceptSet$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="print"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-print'><code>fcaR::ConceptSet$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="size"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-size'><code>fcaR::ConceptSet$size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="sub"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-sub'><code>fcaR::ConceptSet$sub()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="support"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-support'><code>fcaR::ConceptSet$support()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="to_latex"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-to_latex'><code>fcaR::ConceptSet$to_latex()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fcaR" data-topic="ConceptSet" data-id="to_list"><a href='../../fcaR/html/ConceptSet.html#method-ConceptSet-to_list'><code>fcaR::ConceptSet$to_list()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-new"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ConceptLattice} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$new(extents, intents, objects, attributes, I = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extents}}{(\code{dgCMatrix}) The extents of all concepts}

\item{\code{intents}}{(\code{dgCMatrix}) The intents of all concepts}

\item{\code{objects}}{(character vector) Names of the objects in the formal context}

\item{\code{attributes}}{(character vector) Names of the attributes in the formal context}

\item{\code{I}}{(\code{dgCMatrix}) The matrix of the formal context}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ConceptLattice} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-plot"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the concept lattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$plot(
  object_names = TRUE,
  to_latex = FALSE,
  method = c("sugiyama", "force"),
  mode = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object_names}}{(logical) Deprecated. Use \code{mode} instead. If \code{TRUE} (default), implies \code{mode = "reduced"} or similar depending on heuristics. Kept for backward compatibility.}

\item{\code{to_latex}}{(logical) If \code{TRUE}, exports the plot as TikZ code (LaTeX) instead of drawing it. Returns an object of class \code{tikz_code} that prints the LaTeX code to console.}

\item{\code{method}}{(character) The layout algorithm to use. Options are:
\itemize{
\item \code{"sugiyama"} (default): A hierarchical layout that minimizes edge crossings and centers nodes (similar to ConExp or hasseDiagram).
\item \code{"force"}: A force-directed (spring) layout, useful for large or non-hierarchical lattices.
}}

\item{\code{mode}}{(character) The labeling mode for the nodes. If \code{NULL} (default), a heuristic based on lattice size is used. Options are:
\itemize{
\item \code{"reduced"}: Standard FCA labeling. Nodes are labeled with an attribute (or object) only if they are the supreme (or infimum) of that attribute (or object).
\item \code{"full"}: Each node shows its complete extent and intent.
\item \code{"attributes"}: Nodes show only their intent (attributes).
\item \code{"empty"}: Nodes are drawn as points without labels. Recommended for very large lattices (>50 concepts).
}}

\item{\code{...}}{Other parameters passed to the internal plotting function (e.g., graphical parameters for \code{ggraph}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{to_latex} is \code{FALSE}, it returns (invisibly) the \code{ggplot2} object representing the graph.
If \code{to_latex} is \code{TRUE}, it returns a \code{tikz_code} object containing the LaTeX code.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-sublattice"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-sublattice}{}}}
\subsection{Method \code{sublattice()}}{
Sublattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$sublattice(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
As argument, one can provide both integer indices or \code{Concepts}, separated by commas. The corresponding concepts are used to generate a sublattice.
}

\subsection{Returns}{
The generated sublattice as a new \code{ConceptLattice} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-top"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-top}{}}}
\subsection{Method \code{top()}}{
Top of a Lattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$top()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The top of the Concept Lattice
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fc <- FormalContext$new(planets)
fc$find_concepts()
fc$concepts$top()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-bottom"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-bottom}{}}}
\subsection{Method \code{bottom()}}{
Bottom of a Lattice
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$bottom()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The bottom of the Concept Lattice
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{fc <- FormalContext$new(planets)
fc$find_concepts()
fc$concepts$bottom()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-join_irreducibles"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-join_irreducibles}{}}}
\subsection{Method \code{join_irreducibles()}}{
Join-irreducible Elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$join_irreducibles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The join-irreducible elements in the concept lattice.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-meet_irreducibles"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-meet_irreducibles}{}}}
\subsection{Method \code{meet_irreducibles()}}{
Meet-irreducible Elements
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$meet_irreducibles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The meet-irreducible elements in the concept lattice.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-decompose"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-decompose}{}}}
\subsection{Method \code{decompose()}}{
Decompose a concept as the supremum of meet-irreducible concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$decompose(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{A list of \code{Concept}s}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list, each field is the set of meet-irreducible elements whose supremum is the corresponding element in \code{C}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-supremum"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-supremum}{}}}
\subsection{Method \code{supremum()}}{
Supremum of Concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$supremum(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
As argument, one can provide both integer indices or \code{Concepts}, separated by commas. The corresponding concepts are used to compute their supremum in the lattice.
}

\subsection{Returns}{
The supremum of the list of concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-infimum"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-infimum}{}}}
\subsection{Method \code{infimum()}}{
Infimum of Concepts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$infimum(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
As argument, one can provide both integer indices or \code{Concepts}, separated by commas. The corresponding concepts are used to compute their infimum in the lattice.
}

\subsection{Returns}{
The infimum of the list of concepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-subconcepts"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-subconcepts}{}}}
\subsection{Method \code{subconcepts()}}{
Subconcepts of a Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$subconcepts(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{(numeric or \code{SparseConcept}) The concept to which determine all its subconcepts.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the subconcepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-superconcepts"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-superconcepts}{}}}
\subsection{Method \code{superconcepts()}}{
Superconcepts of a Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$superconcepts(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{(numeric or \code{SparseConcept}) The concept to which determine all its superconcepts.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the superconcepts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-lower_neighbours"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-lower_neighbours}{}}}
\subsection{Method \code{lower_neighbours()}}{
Lower Neighbours of a Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$lower_neighbours(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{(\code{SparseConcept}) The concept to which find its lower neighbours}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the lower neighbours of \code{C}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-upper_neighbours"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-upper_neighbours}{}}}
\subsection{Method \code{upper_neighbours()}}{
Upper Neighbours of a Concept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$upper_neighbours(C)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{C}}{(\code{SparseConcept}) The concept to which find its upper neighbours}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the upper neighbours of \code{C}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-stability"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-stability}{}}}
\subsection{Method \code{stability()}}{
Computes the stability of each concept.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$stability()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector with the stability of each concept.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-separation"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-separation}{}}}
\subsection{Method \code{separation()}}{
Computes the separation of each concept.
Separation is the number of objects covered by the concept but not by any of its immediate subconcepts.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$separation()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector with the separation of each concept.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-density"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-density}{}}}
\subsection{Method \code{density()}}{
Computes the fuzzy density of each concept.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$density(I = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{I}}{(Optional) The original incidence matrix. If NULL, it tries to access it from the parent FormalContext if linked.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector with the density of each concept.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-is_distributive"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-is_distributive}{}}}
\subsection{Method \code{is_distributive()}}{
Check if the lattice is distributive.
A lattice is distributive if \eqn{x \wedge (y \vee z) = (x \wedge y) \vee (x \wedge z)} for all elements.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$is_distributive()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-is_modular"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-is_modular}{}}}
\subsection{Method \code{is_modular()}}{
Check if the lattice is modular.
A lattice is modular if \eqn{x \le z \implies x \vee (y \wedge z) = (x \vee y) \wedge z}.
Distributive lattices are always modular.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$is_modular()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-is_semimodular"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-is_semimodular}{}}}
\subsection{Method \code{is_semimodular()}}{
Check if the lattice is upper semimodular.
A lattice is upper semimodular if for every \eqn{x, y}: if \eqn{x} covers \eqn{x \wedge y}, then \eqn{x \vee y} covers \eqn{y}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$is_semimodular()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-is_atomic"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-is_atomic}{}}}
\subsection{Method \code{is_atomic()}}{
Check if the lattice is atomic.
A lattice is atomic if for every element \eqn{x > \bot}, there exists an atom \eqn{a} such that \eqn{a \le x}.
Atoms are elements that cover the bottom element.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$is_atomic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptLattice-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptLattice-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptLattice$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
