% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRR_BaseRFxns.R
\name{generate_randomizations_R}
\alias{generate_randomizations_R}
\title{Generate randomizations in base R, filtering by Hotelling's T^2 acceptance}
\usage{
generate_randomizations_R(
  n_units,
  n_treated,
  X,
  accept_prob,
  random_type,
  max_draws,
  batch_size
)
}
\arguments{
\item{n_units}{Integer, total number of units.}

\item{n_treated}{Integer, number of units to be assigned to treatment.}

\item{X}{Covariate matrix (n_units x p).}

\item{accept_prob}{Numeric in [0, 1]: keep the fraction of randomizations 
that have the lowest T^2 up to this quantile.}

\item{random_type}{Either "exact" or "monte_carlo".}

\item{max_draws}{If `random_type="monte_carlo"`, how many permutations to sample.}

\item{batch_size}{If `random_type="monte_carlo"`, how many permutations to handle per chunk.}
}
\value{
A list with:
  \itemize{
    \item \code{randomizations}: a matrix (rows = accepted assignments).
    \item \code{balance}: numeric vector of T^2 values for each accepted assignment.
  }
}
\description{
Base R function to either do exact enumeration or Monte Carlo random permutations,
then keep the fraction whose T^2 is below the acceptance cutoff.
}
