% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{require.nowarnings}
\alias{require.nowarnings}
\title{Warnings free loading of add-on packages}
\usage{
require.nowarnings(package, lib.loc = NULL, character.only = FALSE)
}
\arguments{
\item{package}{The name of a package, given as a character string.}

\item{lib.loc}{a character vector describing the location of R library trees
to search through, or \code{NULL}.  The default value of \code{NULL}
corresponds to all libraries currently known to \code{.libPaths()}.
Non-existent library trees are silently ignored.}

\item{character.only}{a logical indicating whether \code{package} can be
assumed to be a character string.}
}
\value{
\code{require.nowarnings} returns (invisibly) \code{TRUE} if it succeeds, otherwise \code{FALSE}
}
\description{
Turn off all warnings for require(), to allow clean completion
of examples that require unavailable Suggested packages.
}
\details{
\code{require(package)} acts the same as
\code{require(package, quietly = TRUE)} but with warnings turned off.
In particular, no warning or error is given if the package is unavailable.
Most cases should use \code{requireNamespace(package, quietly = TRUE)} instead,
which doesn't produce warnings.
}
\examples{
## This should produce no output:
if (require.nowarnings(nonexistent)) {
  message("Package loaded successfully")
}
}
\seealso{
\code{\link[=require]{require()}}
}
