% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{plot_kNNdist}
\alias{plot_kNNdist}
\title{Plot kNNdist}
\usage{
plot_kNNdist(
  sessions,
  MinPts = NULL,
  log = getOption("evprof.log", FALSE),
  start = getOption("evprof.start.hour")
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof standard format}

\item{MinPts}{integer, DBSCAN MinPts parameter. If null, a value of 200 will be considered.}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}

\item{start}{integer, start hour in the x axis of the plot.}
}
\value{
plot
}
\description{
Plot the kNN (k-nearest neighbors) distance plot to visually detect the
"elbow" and define an appropriate value for \code{eps} DBSCAN parameter.
}
\details{
The kNN (k-nearest neighbors) distance plot can provide insights into
setting the \code{eps} parameter in DBSCAN. The "elbow" in the kNN distance plot
is the point where the distances start to increase significantly. At the
same time, for DBSCAN, the eps parameter defines the radius within which a
specified number of points must exist for a data point to be considered a
core point. Therefore, the "elbow" of the kNN distance plot can provide a
sense of the scale of the data and help you choose a reasonable range for
the \code{eps} parameter in DBSCAN.
}
\examples{
library(dplyr)
california_ev_sessions \%>\%
  sample_frac(0.05) \%>\%
  plot_kNNdist(start = 3, log = TRUE)

}
