% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2list.R
\name{df2list}
\alias{df2list}
\title{Convert Data Frame to Named List by Grouping}
\usage{
df2list(data, key_col, value_col, verbose = TRUE)
}
\arguments{
\item{data}{A data.frame or tibble to be grouped.}

\item{key_col}{Character. Column name for list names.}

\item{value_col}{Character. Column name for list values.}

\item{verbose}{Logical. Whether to show message. Default = TRUE.}
}
\value{
A named list, where each element is a character vector of values.
}
\description{
Group a data frame by one column and convert to named list.
Each key becomes a list name; each value column becomes vector.
}
\examples{
df <- data.frame(
  cell_type = c("T_cells", "T_cells", "B_cells", "B_cells"),
  marker = c("CD3D", "CD3E", "CD79A", "MS4A1")
)
df2list(df, "cell_type", "marker")
}
