% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hatching.R
\name{Hatching}
\alias{Hatching}
\title{Draws hatching or crosshatching over a mask on a map}
\usage{
Hatching(
  hatching_mask,
  lat,
  lon,
  data = NULL,
  hatching_density = 10,
  hatching_angle = 45,
  hatching_color = "#252525",
  hatching_lwd = 0.5,
  hatching_cross = FALSE
)
}
\arguments{
\item{hatching_mask}{Logical or binary (0/1) array with two named dimensions:
c(latitude, longitude).Hatching is applied to grid cells where
'hatching_mask' is TRUE (or 1). Arrays with dimensions c(longitude, latitude)
are also accepted, but the resulting hatching may appear transposed. To
ensure correct alignment with the map, provide 'data'. The function will
compare the dimension order of 'hatching_mask' and 'data', and automatically
transpose 'hatching_mask' if the latitude and longitude dimensions appear to
be reversed.}

\item{lat}{Numeric vector of latitude locations of the cell centers of the 
grid.}

\item{lon}{Numeric vector of longitude locations of the cell centers of the 
grid.}

\item{data}{Array of the data that the hatching will be drawn over. The array 
should have named latidude and longitude dimensions. If the dimension order
is reversed relative to 'hatching_mask', the mask is automatically
transposed. Default is NULL.}

\item{hatching_density}{The density of shading lines, in lines per inch. A
zero value of density means no shading nor filling, whereas negative values
and NA suppress shading (and so allow color filling). NULL means that no
shading lines are drawn. Default is 10.}

\item{hatching_angle}{The slope of shading lines, given as an angle in degrees
(counter-clockwise). Default is 45.}

\item{hatching_color}{Color of the hatching lines. Default is
\code{"#252525"}.}

\item{hatching_lwd}{The line width, a positive number. The interpretation is
device-specific, and some devices do not implement line widths less than
one. Default is 0.5.}

\item{hatching_cross}{A logical value indicating crosshatching. If TRUE, adds
a second set of lines in the opposite angle. Default is FALSE.}
}
\value{
Invisibly returns \code{NULL}. The function is intended to be used as 
an overlay layer (e.g., when called within \code{VizEquiMap()}). It draws 
hatching or crosshatching onto an existing graphics device.
}
\description{
Adds hatching or crosshatching lines over grid cells of a map based on a 
logical mask. The hatching is applied only to grid cells where the mask is
TRUE (or 1). A number of graphical options are available to customize the
appearance of the hatching, such as line density, angle, line width, and
color. Optionally, crosshatching can be drawn using a second set of lines in
the opposite direction.
The function assumes that the input mask is a 2D array with dimensions
corresponding to latitude (rows) and longitude (columns), and it is designed
to be used as a layer over existing map plots (e.g., within a call to 
\code{VizEquiMap}) and does not initiate a plot by itself.
}
\examples{
mask_small <- array(c(TRUE, FALSE, TRUE, FALSE), dim = c(lat = 2, lon = 2))
lat_small <- 1:2
lon_small <- 1:2
image(lon_small, lat_small, matrix(1:4, nrow = 2))
Hatching(hatching_mask = mask_small, lat = lat_small, lon = lon_small,
         hatching_lwd = 2)
}
