% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.ergm.R
\name{gof}
\alias{gof}
\alias{gof.default}
\alias{gof.ergm}
\alias{gof.formula}
\alias{print.gof}
\alias{plot.gof}
\title{Conduct Goodness-of-Fit Diagnostics on a Exponential Family Random Graph
Model}
\usage{
gof(object, ...)

\method{gof}{ergm}(
  object,
  ...,
  coef = coefficients(object),
  GOF = NULL,
  response = object$network \%ergmlhs\% "response",
  reference = object$reference,
  constraints = object$constraints,
  control = control.gof.ergm(),
  verbose = FALSE
)

\method{gof}{formula}(
  object,
  ...,
  coef = NULL,
  GOF = NULL,
  response = NULL,
  reference = NULL,
  constraints = NULL,
  basis = eval_lhs.formula(object),
  control = NULL,
  unconditional = TRUE,
  verbose = FALSE
)

\method{print}{gof}(x, ...)

\method{plot}{gof}(
  x,
  ...,
  cex.axis = 0.7,
  plotlogodds = FALSE,
  main = "Goodness-of-fit diagnostics",
  normalize.reachability = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{object}{Either a formula or an \code{\link{ergm}} object.
See documentation for \code{\link[=ergm]{ergm()}}.}

\item{\dots}{Additional arguments, to be passed to lower-level functions.}

\item{coef}{When given either a formula or an object of class ergm,
\code{coef} are the parameters from which the sample is drawn. By default
set to a vector of 0. \matchnames{coefficient}}

\item{GOF}{formula; a one-sided formula, of the form \code{~ <model
  terms>} specifying the statistics to use to diagnosis the
goodness-of-fit of the model. They do not need to be in the model
formula specified in \code{formula}, and typically are not. These
can be any \code{ergm()} terms, but the following are given special
meaning: \describe{

\item{the degree distribution}{\code{degree} for undirected
graphs, \code{idegree} and/or \code{odegree} for directed
graphs, and \code{b1degree} and \code{b2degree} for bipartite
undirected graphs}

\item{geodesic distances}{\code{distance}}

\item{shared partner distributions}{\code{espartners} and
\code{dspartners}}

\item{triad census}{\code{triadcensus}}

\item{the cumulative distribution function of edge
values}{\code{cdf(min, max, step, margin, nmax)}, which will be
autodetected from the observed network (using \code{margin} and \code{nmax} if possible)}

\item{terms of the original model}{\code{model}}

}

The default formula for undirected networks is \code{~ degree +
  espartners + distance + model}, for directed networks \code{~
  idegree + odegree + espartners + distance + model}, and for
bipartite \code{~b1degree + b2degree + dspartners +
  distance}. For valued networks, only \code{~cdf} is calculated,
regardless of directedness. By default a \code{model} term is
added to the formula.  It is a very useful overall validity check
and a reminder of the statistical variation in the estimates of
the mean value parameters.  To omit the \code{model} term, add
\code{- model} to the formula.

Ordinary \code{ergm()} terms can also be given on the formula; if
present, they will be returned as "user" statistics.}

\item{response, reference, constraints}{See analogous arguments for \code{\link[=simulate.ergm]{simulate.ergm()}}.}

\item{control}{A list of control parameters for algorithm tuning,
typically constructed with \code{\link[=control.gof.formula]{control.gof.formula()}} or \code{\link[=control.gof.ergm]{control.gof.ergm()}}, which have different
defaults. Their documentation gives the the list of recognized
control parameters and their meaning. The more generic utility
\code{\link[=snctrl]{snctrl()}} (StatNet ConTRoL) also provides argument completion
for the available control functions and limited argument name
checking.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{basis}{a value (usually a \code{\link[network:network]{network}}) to override the LHS of the formula.}

\item{unconditional}{logical; if \code{TRUE}, the simulation is
unconditional on the observed dyads.  if not \code{TRUE}, the simulation is
conditional on the observed dyads. This is primarily used internally when
the network has missing data and a conditional GoF is produced.}

\item{x}{an object of class \code{gof} for printing or plotting.}

\item{cex.axis}{Character expansion of the axis labels relative to that for
the plot.}

\item{plotlogodds}{Plot the odds of a dyad having given characteristics
(e.g., reachability, minimum geodesic distance, shared partners). This is an
alternative to the probability of a dyad having the same property.}

\item{main}{Title for the goodness-of-fit plots.}

\item{normalize.reachability}{Should the reachability proportion be
normalized to make it more comparable with the other geodesic distance
proportions.}
}
\value{
\code{\link[=gof]{gof()}}, \code{\link[=gof.ergm]{gof.ergm()}}, and
\code{\link[=gof.formula]{gof.formula()}} return an object of class \code{gof.ergm}, which inherits from class \code{gof}.  This
is a list of the tables of statistics and \eqn{p}-values.  This is typically
plotted using \code{\link[=plot.gof]{plot.gof()}}.
}
\description{
\code{\link[=gof]{gof()}} calculates \eqn{p}-values for a variety of network features
to diagnose the goodness-of-fit of exponential family random graph
models. For binary networks, these default to geodesic distance,
degree, and reachability summaries. See \code{\link[=ergm]{ergm()}} for more
information on these models.
}
\details{
A sample of graphs is randomly drawn from the specified model.  The first
argument is typically the output of a call to \code{\link[=ergm]{ergm()}} and the
model used for that call is the one fit.

For \code{GOF = ~model}, the model's observed sufficient statistics are
plotted as quantiles of the simulated sample. In a good fit, the observed
statistics should be near the sample median (0.5).

By default, the sample consists of 100 simulated networks, but this sample
size (and many other settings) can be changed using the \code{control}
argument described above.
}
\section{Methods (by class)}{
\itemize{
\item \code{gof(ergm)}: Perform simulation to evaluate goodness-of-fit for
a specific \code{\link[=ergm]{ergm()}} fit.

\item \code{gof(formula)}: Perform simulation to evaluate goodness-of-fit for
a model configuration specified by a \code{\link{formula}}, coefficient,
constraints, and other settings.

}}
\section{Methods (by generic)}{
\itemize{
\item \code{print(gof)}: \code{\link[=print.gof]{print.gof()}} summaries the diagnostics such as the
degree distribution, geodesic distances, shared partner
distributions, and reachability for the goodness-of-fit of
exponential family random graph models. (\code{summary.gof} is a deprecated
alias that may be repurposed in the future.)

\item \code{plot(gof)}: \code{\link[=plot.gof]{plot.gof()}} plots diagnostics such as the degree
distribution, geodesic distances, shared partner distributions, and
reachability for the goodness-of-fit of exponential family random graph
models.

}}
\examples{

\donttest{
data(florentine)
gest <- ergm(flomarriage ~ edges + kstar(2))
gest
summary(gest)

# test the gof.ergm function
gofflo <- gof(gest)
gofflo

# Plot all three on the same page
# with nice margins
par(mfrow=c(1,3))
par(oma=c(0.5,2,1,0.5))
plot(gofflo)

# And now the log-odds
plot(gofflo, plotlogodds=TRUE)

# Use the formula version of gof
gofflo2 <-gof(flomarriage ~ edges + kstar(2), coef=c(-1.6339, 0.0049))
plot(gofflo2)
}

}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link[network:network]{network()}}, \code{\link[=simulate.ergm]{simulate.ergm()}}, \code{\link[=summary.ergm]{summary.ergm()}}
}
\keyword{graphs}
\keyword{models}
