% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqtl.R
\name{pqtl_pleio}
\alias{pqtl_pleio}
\title{Return information related to the pleiotropy of SNPs}
\usage{
pqtl_pleio(
  rsid = NULL,
  prflag = c("proteins", "count"),
  mode = c("table", "raw")
)
}
\arguments{
\item{rsid}{(Required) A SNP identified by rsID which cannot be \code{NULL}.}

\item{prflag}{(Optional) A flag which determines whether the number (if "count")
or names (if "proteins") of the associated proteins should be returned.
The DEFAULT value is "proteins".}

\item{mode}{(Optional) If \code{mode = "table"}, returns a data frame
(a \href{https://tibble.tidyverse.org/}{\code{tibble}} as per
\href{https://style.tidyverse.org/}{\code{tidyverse}} convention).
If \code{mode = "raw"}, returns a raw response from EpiGraphDB API
with minimal parsing done by \href{https://httr.r-lib.org/}{\code{httr}}.}
}
\value{
Data from \verb{GET /pqtl/pleio/}
}
\description{
\href{https://docs.epigraphdb.org/api/api-endpoints/#get-pqtlpleio}{\verb{GET /pqtl/pleio/}}
}
\examples{

# Returns a data frame of associated proteins
\dontrun{
pqtl_pleio(rsid = "rs1260326")
}

# Returns a number of associated proteins
\dontrun{
pqtl_pleio(rsid = "rs1260326", prflag = "count")
}
}
