% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTest2.R
\name{TTest2}
\alias{TTest2}
\title{Perform t-test on easynem meta-table by treatment (two-factor)}
\usage{
TTest2(data, .group1, .group2, y, ...)
}
\arguments{
\item{data}{An \code{\link{easynem-class}} data.}

\item{.group1}{Grouping variables factor 1 (supports only two groups).}

\item{.group2}{Grouping variables factor 2 (supports only two groups).}

\item{y}{Dependent variable (numeric data).}

\item{...}{Other parameters for \code{\link[stats]{t.test}}.}
}
\value{
An \code{\link{compare2-class}} object.
}
\description{
The \code{TTest2()} is used to perform \code{t-test} for grouped data and create
\code{\link{compare2-class}}. This function is only applicable to two-factor
analysis, see \code{\link{TTest}} for a single factor version of the function.
}
\details{
Note: The \code{t-test} is only applicable to comparisons between two groups
of data. To facilitate code interpretation, It is recommended to use this
function in conjunction with the \code{\link{calc_compare2}} function:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_compare <- nem |> calc_compare2(.group1 = con_crop, .group2 = season, y = pH, method = TTest2)
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem(tab = easynem_example("nemtab1.csv"),
                tax = easynem_example("nemtax1.csv"),
                meta = easynem_example("nemmeta1.csv"))
nem_ttest <- nem |>
              filter_name(meta, con_crop \%in\% c("Y2", "Y11")) |>
              calc_compare2(.group1 = con_crop, .group2 = season, y = pH, method = TTest2)
nem_ttest
}
\seealso{
Other functions related to differential analysis methods: \code{\link{TTest}},
\code{\link{WilcoxTest}}, \code{\link{WilcoxTest2}}, \code{\link{KruskalTest}},
\code{\link{KruskalTest2}}, \code{\link{LSD}}, \code{\link{LSD2}}, \code{\link{HSD}},
\code{\link{HSD2}}.
}
