% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_mixture_2D.R
\name{gaussian_mixture_2D}
\alias{gaussian_mixture_2D}
\title{Gaussian mixture decomposition for 2D data}
\usage{
gaussian_mixture_2D(X, Y = NULL, opts = NULL)
}
\arguments{
\item{X}{Matrix of 2D data to decompose by GMM.}

\item{Y}{Vector of counts, with the same length as "X".
Applies only to binned data (Y = NULL, by default).}

\item{opts}{Parameters of run saved in \code{\link{GMM_2D_opts}} variable.}
}
\value{
Function returns a \code{list} of GMM parameters for the optimal number of components: \describe{
 \item{alpha}{Weights (alpha) of each component.}
 \item{center}{Means of decomposition.}
 \item{covar}{Covariances of each component.}
 \item{KS}{Estimated number of components.}
 \item{logL}{Log-likelihood statistic for the estimated number of components.}
 \item{IC}{The value of the selected information criterion which was used to calculate the number of components.}
 \item{cls}{Assigment of point to the clusters.}
}
}
\description{
Function to choose the optimal number of components of a 2D mixture normal distributions, minimizing the value of the information criterion.
}
\examples{
\donttest{
data(example2D)
custom.settings <- GMM_2D_opts
exp <- gaussian_mixture_2D(example2D[,1:2], example2D[,3], opts = custom.settings)
}

}
\seealso{
\code{\link{runGMM2D}}, \code{\link{GMM_2D_opts}}
}
