% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_tdv_grasp.R
\name{partition_tdv_grasp}
\alias{partition_tdv_grasp}
\title{Obtain a partition using a GRASP algorithm}
\usage{
partition_tdv_grasp(m_bin, k, thr = 0.95, verify = TRUE)
}
\arguments{
\item{m_bin}{A matrix. A phytosociological table of 0s (absences) and 1s
(presences), where rows correspond to taxa and columns correspond to
relevés.}

\item{k}{A numeric giving the number of desired groups.}

\item{thr}{A numeric giving a threshold value (from 0 to 1 ) with the
probability used to compute the sample quantile, in order to get the best
\code{m_bin} columns from which to select one to be include in the GRASP
solution (in each step of the procedure).}

\item{verify}{A logical. If \code{TRUE} (the default) the function verifies if
basic features of \code{m_bin} data structure are met. Otherwise if \code{FALSE}.}
}
\value{
A numeric vector, which length is the same as the number of columns
of \code{m_bin}, with numbers from 1 to \code{k}, representing the group to which the
respective column was ascribed.
}
\description{
This function obtains a partition of the columns of a given phytosociological
matrix, aiming at high values of the Total Differential Value (TDV) using a
GRASP algorithm.
}
\details{
This function uses a Greedy Randomized Adaptive Search Procedure
(GRASP) to obtain a partition of \code{m_bin}.
Given a phytosociological table (\code{m_bin}, with rows corresponding to taxa
and columns corresponding to relevés) this function searches for a
\code{k}-partition (\code{k}, defined by the user) aiming at high values of the TDV.
See \code{\link[=tdv]{tdv()}} for an explanation on the TDV of a phytosociological table.

With \code{thr = 1}, the algorithm corresponds to the Greedy algorithm.
}
\examples{
# Getting the Taxus baccata forests data set
data(taxus_bin)

# Obtaining a partition based on the GRASP algorithm
partition_tdv_grasp(taxus_bin, 3)

}
\author{
Jorge Orestes Cerdeira and Tiago Monteiro-Henriques.
E-mail: \email{tmh.dev@icloud.com}.
}
