% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{sum_cor}
\alias{sum_cor}
\title{Summarize Correlations Between a Reference Variable and Others}
\usage{
sum_cor(
  data,
  ref_var,
  compare_vars,
  by = NULL,
  method = "pearson",
  digits = 3,
  report = TRUE
)
}
\arguments{
\item{data}{A data frame containing the variables of interest.}

\item{ref_var}{The reference variable (numeric) for correlation calculations.}

\item{compare_vars}{A character vector of variables to correlate with the reference variable.}

\item{by}{Optional grouping variable. If provided, correlations are calculated within each group.}

\item{method}{Correlation method. Options: "pearson", "spearman", or "kendall" (default: "pearson").}

\item{digits}{Number of decimal places to round correlation coefficients and CIs (default: 3).}

\item{report}{Logical. If TRUE, prints a narrative summary of correlations (default: TRUE).}
}
\value{
A \code{flextable} object showing correlations, 95\% CI (Pearson only), p-values, and interpretation.
}
\description{
Computes correlations between a reference variable and one or more comparison variables.
For Pearson correlations, 95\% confidence intervals are also calculated.
Can optionally stratify by a grouping variable. Returns a formatted \code{flextable}
and optionally prints a narrative summary describing weak, moderate, and strong correlations.
}
\examples{
# Example 1: Correlations across entire dataset
sum_cor(
  data = iris,
  ref_var = "Sepal.Length",
  compare_vars = c("Petal.Length", "Petal.Width", "Sepal.Width"),
  method = "pearson",
  digits = 2,
  report = TRUE
)

# Example 2: Correlations by Species
sum_cor(
  data = iris,
  ref_var = "Sepal.Length",
  by = "Species",
  compare_vars = c("Petal.Length", "Petal.Width", "Sepal.Width"),
  method = "pearson",
  digits = 2,
  report = TRUE
)
}
