% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\name{downloadObject}
\alias{downloadObject}
\alias{downloadObject,D1Client-method}
\title{Download an object from the DataONE Federation to Disk.}
\usage{
downloadObject(x, identifier, ...)

\S4method{downloadObject}{D1Client}(x, identifier, path = getwd(), check = as.logical(TRUE))
}
\arguments{
\item{x}{A D1Client object.}

\item{identifier}{The identifier of the object to get.}

\item{...}{(Not yet used.)}

\item{path}{(optional) Path to a directory to write object to. The name of the file will be determined from the
SystemMetada of the object (see details for more information).
The function will fail if a file with the same name already exists in the directory.}

\item{check}{(optional) A logical value, if TRUE check if this object has been obsoleted by another object in DataONE.}
}
\value{
A path where the ouput file is written to.
}
\description{
A convenience method to download an object to disk.
}
\details{
This method performs multiple underlying calls to the DataONE repository network.
CN.resolve() is called to locate the object on one or more repositories, and then each of these
is accessed until success at downloading the associated SystemMetadata for the object.
The SystemMetadata is used to assign a name to the file that is output to disk. If a fileName is specified in
the SystemMetadata, then the file output to disk will be named according to the SystemMetadata fileName.
If there is not a specified SystemMetadata fileName, the identifier will be used as the file name output to disk.
If the identifier is used as the file name, a file name extension will be determined using the SystemMetadata
formatID along with information from CNCore.listFormats(). If the SystemMetadata formatID is
"application/octet-stream" no extension will be written.
}
\examples{
\dontrun{
library(dataone)
d1c <- D1Client("PROD", "urn:node:KNB")
pid <- "solson.5.1"
path <- downloadObject(d1c, pid)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client()}} class description.
}
