% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_variable.R
\name{tab_freq_cont}
\alias{tab_freq_cont}
\title{Generate a frequency table to a continuous variable.}
\usage{
tab_freq_cont(
  data,
  variable,
  breaks = NULL,
  labels = NULL,
  include_lowest = TRUE,
  right = FALSE
)
}
\arguments{
\item{data}{dataframe object}

\item{variable}{variable name as character}

\item{breaks}{either a integer number or vector of number. Defaults to \code{NULL}}

\item{labels}{label for each interval. Defaults to  interval names using
brackes and parentheses. Defaults to \code{NULL}.}

\item{include_lowest}{logical value. If \code{TRUE}, the lower limit of interval
belongs to the bin. Defaults to \code{TRUE}.}

\item{right}{logical value. If \code{TRUE}, the upper limit of interval belongs to
the bin. Defaults to \code{FALSE}.}
}
\value{
a dataframe with distribution frequency
}
\description{
Bin the continuous variable, and count the occurrence of each interval.
}
\details{
if \code{breaks = NULL}, then \code{ceiling(1 + log2(n))}, where \code{n} is the
sample size.
}
\examples{
tab_freq_cont(iris, "Sepal.Width")
}
