% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestProbMTDLTE-class}
\alias{NextBestProbMTDLTE-class}
\alias{.NextBestProbMTDLTE}
\alias{NextBestProbMTDLTE}
\alias{.DefaultNextBestProbMTDLTE}
\title{\code{NextBestProbMTDLTE}}
\usage{
NextBestProbMTDLTE(target)

.DefaultNextBestProbMTDLTE()
}
\arguments{
\item{target}{(\code{numeric})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{NextBestProbMTDLTE}} is the class of finding a next best dose that selects
the dose with the highest probability of having a toxicity rate less or equal
to the toxicity target.
The dose is determined by calculating the posterior toxicity probability
for each dose per iteration and select the maximum dose that has a toxicity
probability below or equal to the target. The dose with the highest frequency
of being selected as MTD across iterations is the next best dose. Placebo
is not considered in the calculation and removed from the dose grid for
any calculations.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{numeric})\cr the target toxicity probability.}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestProbMTDLTE()} function.
}
\examples{
# In the example below, the MTD is defined as the dose with the highest
# probability of having a toxicity rate below 30\%.
next_best_prob_mtd_lte <- NextBestProbMTDLTE(target = 0.3)
}
