% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{mleLR}
\alias{mleLR}
\title{Maximum Likelihood Estimate for multinomial logit-normal model}
\usage{
mleLR(
  y,
  max.iter = 10000,
  max.iter.nr = 100,
  tol = 1e-06,
  tol.nr = 1e-06,
  lambda.gl = 0,
  gamma = 0.1,
  lr.penalty = c("alr", "clr"),
  verbose = FALSE
)
}
\arguments{
\item{y}{Matrix of counts; samples are rows and features are columns.}

\item{max.iter}{Maximum number of iterations}

\item{max.iter.nr}{Maximum number of Newton-Raphson iterations}

\item{tol}{Stopping rule}

\item{tol.nr}{Stopping rule for the Newton-Raphson algorithm}

\item{lambda.gl}{Penalization parameter lambda, for the graphical lasso penalty. Controls
the sparsity of Sigma}

\item{gamma}{Gamma value for EBIC calculation of the log-likelihood}

\item{lr.penalty}{Should the precision matrix be penalized on the ALR or CLR scale?}

\item{verbose}{If TRUE, print information as the functions run}
}
\value{
The additive log-ratio of y (\code{v}); maximum likelihood estimates of
\code{mu}, \code{Sigma}, and \code{Sigma.inv} (e.g. the covariance and precision matrices)
on the ALR scale.  The CLR scale versions are \code{Sigma.clr} and \code{Sigma.inv.clr}, respectively;
the log-likelihood (\code{log.lik}); the EBIC (extended Bayesian information criterion)
of the log-likelihood of the multinomial logit-Normal model with the
graphical lasso penalty (\code{ebic}); degrees of freedom of the \code{Sigma.inv}
matrix (\code{df}).
}
\description{
Returns the maximum likelihood estimates of multinomial logit-normal model
parameters given a count-compositional dataset. The MLE procedure is based on the
multinomial logit-Normal distribution, using the EM algorithm from Hoff (2003).
}
\note{
The graphical lasso penalty
is the sum of the absolute value of the elements of the covariance matrix \code{Sigma}.
The penalization parameter lambda controls the sparsity of Sigma.

This function is also used within the \code{mlePath()} function.
}
\examples{
data(singlecell)
mle <- mleLR(singlecell)

mle$mu
mle$Sigma
mle$ebic

}
