% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment.R
\name{Addcoord2embed}
\alias{Addcoord2embed}
\title{Add the spatial coordinates to the reduction slot}
\usage{
Addcoord2embed(seu, coord.name, assay = "RNA")
}
\arguments{
\item{seu}{a SeuratObject with spatial coordinate information in the \code{meta.data} slot.}

\item{coord.name}{a character vector, specify the names of spatial coordinates in the \code{meta.data} slot. For example, \code{c("x", "y")}.}

\item{assay}{a string, specify the assay.}
}
\value{
return a revised Seurat object with a slot `Spatial` in the reductions slot.
}
\description{
Calculate the adjacency matrix given a spatial coordinate matrix with 2-dimension or 3-dimension or more.
}
\examples{
data(CosMx_subset)
library(Seurat)
Addcoord2embed(CosMx_subset, coord.name = c("x", "y"))


}
\references{
None
}
\seealso{
None
}
