% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{makeMat}
\alias{makeMat}
\title{Create a matrix of given size filled with a constant value}
\usage{
makeMat(n, m, value)
}
\arguments{
\item{n}{An integer representing the number of rows in the matrix.}

\item{m}{An integer representing the number of columns in the matrix.}

\item{value}{A numeric value that will be used to fill the matrix.}
}
\value{
A numeric matrix of dimensions \verb{n x m} filled with the specified value.
}
\description{
This function creates an \verb{n x m} matrix of type \code{Eigen::MatrixXd}, where each
element is set to the specified constant value. This is useful for generating
matrices with uniform values for testing, initialization, or other purposes in
computational tasks where a matrix filled with a constant is needed.
}
\details{
The \code{makeMat} function generates a matrix with the given dimensions \verb{n x m}
where all elements are initialized to the same constant value. It is useful
in scenarios where a specific value needs to be assigned to all elements of the
matrix, for example in machine learning algorithms, matrix manipulations, or tests.
}
\examples{
library(cmpp)
# Create a 3x3 matrix filled with 5
mat <- makeMat(3, 3, 5)
print(mat)
}
