% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-graphml.R
\name{write_graphml}
\alias{write_graphml}
\title{Write caugi Graph to GraphML File}
\usage{
write_graphml(x, path)
}
\arguments{
\item{x}{A \code{caugi} object.}

\item{path}{File path for the output GraphML file.}
}
\value{
Invisibly returns \code{NULL}. Called for side effects.
}
\description{
Exports a caugi graph to a GraphML file.
}
\examples{
cg <- caugi(A \%-->\% B + C, class = "DAG")

tmp <- tempfile(fileext = ".graphml")
write_graphml(cg, tmp)

# Read it back
cg2 <- read_graphml(tmp)

# Clean up
unlink(tmp)

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_mermaid}()}
}
\concept{export}
