% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{.not_m_separated_for_all_subsets}
\alias{.not_m_separated_for_all_subsets}
\title{Check if nodes are NOT m-separated for all conditioning subsets}
\usage{
.not_m_separated_for_all_subsets(cg, node_a, node_b, other_nodes, cond_vars)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{node_a}{First node name.}

\item{node_b}{Second node name.}

\item{other_nodes}{Other remaining nodes to form conditioning sets from.}

\item{cond_vars}{Conditioning variables (always included in conditioning).}
}
\value{
\code{TRUE} if nodes are not m-separated for any subset (i.e., adjacent).
}
\description{
Tests whether two nodes fail to be m-separated for every possible
conditioning set formed from \code{other_nodes} combined with \code{cond_vars}.
If they are never separated, they must be adjacent in the resulting graph.
}
\keyword{internal}
