% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{axe-train}
\alias{axe-train}
\alias{axe_call.train}
\alias{axe_ctrl.train}
\alias{axe_data.train}
\alias{axe_env.train}
\alias{axe_fitted.train}
\title{Axing a train object.}
\usage{
\method{axe_call}{train}(x, verbose = FALSE, ...)

\method{axe_ctrl}{train}(x, verbose = FALSE, ...)

\method{axe_data}{train}(x, verbose = FALSE, ...)

\method{axe_env}{train}(x, verbose = FALSE, ...)

\method{axe_fitted}{train}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed train object.
}
\description{
train objects are created from the \pkg{caret} package.
}
\examples{
\dontshow{if (rlang::is_installed("caret")) withAutoprint(\{ # examplesIf}
# Load libraries
library(caret)

data(iris)
train_data <- iris[, 1:4]
train_classes <- iris[, 5]

train_fit <- train(train_data, train_classes,
                   method = "knn",
                   preProcess = c("center", "scale"),
                   tuneLength = 10,
                   trControl = trainControl(method = "cv"))

out <- butcher(train_fit, verbose = TRUE)
\dontshow{\}) # examplesIf}
}
