% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_server_yml}
\alias{validate_server_yml}
\title{Validate a _server.yml file}
\usage{
validate_server_yml(path, check_engine = FALSE, verbose = TRUE)
}
\arguments{
\item{path}{Path to the directory containing \verb{_server.yml} or path to the
\verb{_server.yml} file itself.}

\item{check_engine}{Logical. If \code{TRUE}, checks that the engine package is
installed and has a \code{launch_server()} function. Default is \code{FALSE} since
the engine may not be installed locally but will be on the deployment target.}

\item{verbose}{Logical. If \code{TRUE}, prints validation progress messages.}
}
\value{
Invisibly returns \code{TRUE} if validation passes. Throws an error if
validation fails.
}
\description{
Checks that a \verb{_server.yml} file is properly formatted according to the
_server.yml standard. This includes verifying that the engine field exists
and that the specified engine package has a \code{launch_server()} function.
}
\details{
The validation checks:
\itemize{
\item The \verb{_server.yml} file exists
\item The file is valid YAML
\item The required \code{engine} field is present and is a character string
\item If \code{check_engine = TRUE}, verifies the engine package is installed and
has a \code{launch_server()} function
}
}
\examples{
\dontrun{
# Validate a directory containing _server.yml
validate_server_yml("path/to/api")

# Validate and check that the engine is installed
validate_server_yml("path/to/api", check_engine = TRUE)
}
}
