% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_survival_curves}
\alias{br_show_survival_curves}
\title{Show survival curves based on model scores}
\usage{
br_show_survival_curves(
  breg,
  idx = NULL,
  n_groups = 3,
  group_labels = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{breg}{A \code{breg} object with fitted Cox regression models.}

\item{idx}{Index or name of the model to use for prediction.
If NULL, uses the first model.}

\item{n_groups}{Number of groups to create based on score quantiles. Default is 3.}

\item{group_labels}{Custom labels for the groups. If NULL, uses "Low", "Medium", "High"
for 3 groups or "Q1", "Q2", etc. for other numbers.}

\item{title}{Plot title. If NULL, generates automatic title.}

\item{subtitle}{Plot subtitle.}
}
\value{
A ggplot2 object showing survival curves.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Generate survival curves by grouping observations based on model prediction scores.
This function is specifically designed for Cox regression models and creates
survival curves comparing different risk groups.
}
\examples{
\donttest{
# Cox regression example with survival curves
if (requireNamespace("survival", quietly = TRUE)) {
  lung <- survival::lung |> dplyr::filter(ph.ecog != 3)
  mds <- br_pipeline(
    lung,
    y = c("time", "status"),
    x = c("age", "ph.ecog"),
    x2 = "sex",
    method = "coxph"
  )
  p <- br_show_survival_curves(mds)
  print(p)
}
}
}
\seealso{
Other br_show: 
\code{\link{br_show_coxph_diagnostics}()},
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
