% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_variance_decompositions.R
\name{compute_variance_decompositions.PosteriorBVARs}
\alias{compute_variance_decompositions.PosteriorBVARs}
\title{Computes posterior draws of the forecast error variance decomposition}
\usage{
\method{compute_variance_decompositions}{PosteriorBVARs}(posterior, horizon)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBVARs} obtained by running the \code{estimate} function.}

\item{horizon}{a positive integer number denoting the forecast horizon for 
the forecast error variance decompositions.}
}
\value{
An object of class \code{PosteriorFEVDPANEL}, that is, a list with 
\code{C} elements containing \code{NxNx(horizon+1)xS} arrays of class 
\code{PosteriorFEVD} with \code{S} draws of country-specific forecast error 
variance decompositions.
}
\description{
For each country, each of the draws from the posterior estimation 
of the model is transformed into a draw from the posterior distribution of the forecast 
error variance decomposition.
}
\examples{
# specify the model and set seed
specification  = specify_bvars$new(ilo_dynamic_panel[1:5]) # specify the model

# run the burn-in
burn_in        = estimate(specification, 5)

# estimate the model
posterior      = estimate(burn_in, 5)

# compute forecast error variance decomposition 4 years ahead
fevd           = compute_variance_decompositions(posterior, horizon = 4)

}
\references{
Lütkepohl, H. (2017). Structural VAR Tools, Chapter 4, In: Structural vector autoregressive analysis. Cambridge University Press.
}
\seealso{
\code{\link{estimate.PosteriorBVARs}}, 
\code{\link{summary.PosteriorFEVDPANEL}}, 
\code{\link{plot.PosteriorFEVDPANEL}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
