% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_gaussian_distribution.R
\name{inverse_gaussian_distribution}
\alias{inverse_gaussian_distribution}
\alias{inverse_gaussian_pdf}
\alias{inverse_gaussian_lpdf}
\alias{inverse_gaussian_cdf}
\alias{inverse_gaussian_lcdf}
\alias{inverse_gaussian_quantile}
\title{Inverse Gaussian Distribution Functions}
\usage{
inverse_gaussian_distribution(mu = 1, lambda = 1)

inverse_gaussian_pdf(x, mu = 1, lambda = 1)

inverse_gaussian_lpdf(x, mu = 1, lambda = 1)

inverse_gaussian_cdf(x, mu = 1, lambda = 1)

inverse_gaussian_lcdf(x, mu = 1, lambda = 1)

inverse_gaussian_quantile(p, mu = 1, lambda = 1)
}
\arguments{
\item{mu}{mean parameter (mu > 0; default is 1)}

\item{lambda}{scale parameter (lambda > 0; default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Inverse Gaussian distribution.
}
\examples{
# Inverse Gaussian distribution with mu = 3, lambda = 4
dist <- inverse_gaussian_distribution(3, 4)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
inverse_gaussian_pdf(2, 3, 4)
inverse_gaussian_lpdf(2, 3, 4)
inverse_gaussian_cdf(2, 3, 4)
inverse_gaussian_lcdf(2, 3, 4)
inverse_gaussian_quantile(0.5, 3, 4)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/inverse_gaussian_dist.html}{Boost Documentation} for more details on the mathematical background.
}
