% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genhol.R
\name{genhol}
\alias{genhol}
\title{Generate a moving-holiday regressor for weekly data}
\usage{
genhol(dates, holiday.dates, start = 7, end = 7)
}
\arguments{
\item{dates}{A vector of class \code{"Date"} corresponding to the weekly
observation dates.}

\item{holiday.dates}{A vector of class \code{"Date"} giving the holiday
occurrence dates (e.g., Easter, Labor Day, Thanksgiving, Rosh Hashanah,
Pesach). Dates outside the range of \code{dates} are ignored.}

\item{start}{Integer. Number of days before each holiday date to include in the
moving-holiday window. Negative values may be used to shift the start of the
window to dates after the holiday.}

\item{end}{Integer. Number of days after each holiday date to include in the
moving-holiday window. Negative values may be used to shift the end of the
window to dates before the holiday.}
}
\value{
A data frame with two columns:
\describe{
\item{date}{Weekly dates corresponding to \code{dates}.}
\item{moving_holiday}{Calendar-centered moving-holiday regressor at weekly
frequency.}
}
The returned object can be merged into a matrix of holiday or trading-day
regressors supplied to \code{boiwsa()} via the \code{H} argument.
}
\description{
Generates moving-holiday regressors for weekly data based on supplied holiday
occurrence dates using the Easter formula described in
Table 2 of Findley et al. (1998). The function can be used to construct
regressors for U.S. holidays such as Easter, Labor Day, and Thanksgiving, as
well as for Israeli holidays such as Rosh Hashanah and Pesach. The resulting
weekly holiday regressors are calendar-centered to avoid bias.
}
\examples{

# Moving-holiday regressor for Israeli Rosh Hashanah
data(gasoline.data)
data(holiday_dates_il) # dates of Israeli Rosh Hashanah and Pesach
movehol=genhol(gasoline.data$date,holiday.dates = holiday_dates_il$rosh)


}
\references{
Findley, D.F., Monsell, B.C., Bell, W.R., Otto, M.C. and B.C Chen (1998). New capabilities and methods of the X-12-ARIMA seasonal-adjustment program. Journal of Business & Economic Statistics, 16(2), pp.127-152.
}
