% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-class.R
\name{new_dock_layout}
\alias{new_dock_layout}
\alias{default_grid}
\alias{create_dock_layout}
\alias{is_dock_layout}
\alias{validate_dock_layout}
\alias{as_dock_layout}
\title{Dock layout}
\usage{
new_dock_layout(grid = NULL, panels = NULL, active_group = NULL)

default_grid(blocks, extensions)

create_dock_layout(
  blocks = list(),
  extensions = list(),
  grid = default_grid(blocks, extensions)
)

is_dock_layout(x)

validate_dock_layout(x, blocks = character())

as_dock_layout(x, ...)
}
\arguments{
\item{grid, panels, active_group}{Layout components}

\item{blocks, extensions}{Dock board components}

\item{x}{Object}

\item{...}{Generic consistency}
}
\value{
The constructor \code{new_dock_layout()}, as does the high-level utility
\code{create_dock_layout()}, as well as the coercion function \code{as_dock_layout()},
all return a \code{dock_layout} object. A helper function for specifying a default
grid is available as \code{default_grid()}, which returns a list of character
vectors. The validator \code{validate_dock_layout()} returns its input and throws
errors as side-effect and inheritance can be checked using \code{is_dock_layout}
which returns a boolean.
}
\description{
The arrangement of panels in a dock can be specified using a \code{dock_layout}
object. A default layout is available via \code{default_grid()} which results
in two panel groups, the one on the left containing all extension panels
and the one on the right all block panels. Complementing the low-level
constructor \code{new_dock_layout()}, a high-level entry point
\code{create_dock_layout()} will create panels for extensions and blocks, which
can then be arranged via a nested list of character vectors passed as
\code{grid} argument.
}
\examples{
blks <- c(
  a = blockr.core::new_dataset_block(),
  b = blockr.core::new_head_block()
)

exts <- list(
  edit = new_edit_board_extension()
)

grid <- list("edit", list("a", "b"))

layout <- create_dock_layout(blks, exts, grid)
is_dock_layout(layout)

}
