% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censoring-summary.R
\name{brs_cens}
\alias{brs_cens}
\title{Graphical and tabular censoring summary}
\usage{
brs_cens(
  object,
  n_sample = 100L,
  which = 1:4,
  caption = NULL,
  gg = FALSE,
  title = "Censoring diagnostic overview",
  sub.caption = NULL,
  theme = NULL,
  palette = NULL,
  inform = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted \code{"brs"} object, a matrix
returned by \code{\link{brs_check}}, or a data frame
returned by \code{\link{brs_prep}} (must contain columns
\code{left}, \code{right}, \code{yt}, and \code{delta}).}

\item{n_sample}{Integer: maximum number of observations to show
in the interval plot (default 100).  If the data has more
observations, a random sample is drawn.}

\item{which}{Integer vector selecting which panels to draw
(default \code{1:4}).}

\item{caption}{Optional panel captions. Accepts a character vector
(or list coercible to character) with up to 4 labels, in the order:
burden, midpoint-by-type, width-by-type, ordered interval map.}

\item{gg}{Logical: use ggplot2? (default \code{FALSE}).}

\item{title}{Optional global title for the plotting page.}

\item{sub.caption}{Optional subtitle/caption for the plotting page.}

\item{theme}{Optional ggplot2 theme object (e.g., \code{ggplot2::theme_bw()}).
If \code{NULL}, a minimal theme is used when \code{gg = TRUE}.}

\item{palette}{Optional named character vector with colors for censoring
types \code{Exact}, \code{Left}, \code{Right}, and \code{Interval}.}

\item{inform}{Logical; if \code{TRUE}, prints brief interpretation
messages about boundary and interval censoring intensity.}

\item{...}{Further arguments (currently ignored).}
}
\value{
Invisibly returns a data frame with censoring counts and
  proportions, percentages, and interpretation flags.
}
\description{
Produces a visual summary of the censoring structure in a fitted
\code{"brs"} model or a response matrix produced by
\code{\link{brs_check}}.  The summary includes:
\enumerate{
  \item Bar chart of censoring type counts
  \item Histogram of midpoint responses colored by censoring type
  \item Interval plot showing \eqn{[l_i, u_i]} segments
  \item Proportion table of censoring types
}
}
\examples{
y <- c(0, 3, 5, 7, 10)
Y <- brs_check(y, ncuts = 10)
brs_cens(Y)

prep <- brs_prep(data.frame(y = y), ncuts = 10)
brs_cens(prep)

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
