% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.brs_bootstrap}
\alias{autoplot.brs_bootstrap}
\title{ggplot2 autoplot for bootstrap results}
\usage{
\method{autoplot}{brs_bootstrap}(
  object,
  type = c("ci_forest", "dist", "qq", "stability"),
  parameter = NULL,
  title = NULL,
  caption = NULL,
  max_parameters = 12L,
  ci_level = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"brs_bootstrap"}.}

\item{type}{Plot type:
\code{"ci_forest"}, \code{"dist"}, \code{"qq"}, or \code{"stability"}.}

\item{parameter}{Optional parameter name used by \code{type = "dist"},
\code{"qq"}, and \code{"stability"}. If \code{NULL}, the first parameter
is used.}

\item{title}{Optional plot title override.}

\item{caption}{Optional subtitles/titles for plot types. Accepts:
\itemize{
  \item a single string (used for the selected \code{type});
  \item a character vector/list with up to four entries in the order
    \code{ci_forest}, \code{dist}, \code{qq}, \code{stability}.
}}

\item{max_parameters}{Maximum number of parameters shown in
\code{type = "ci_forest"}.}

\item{ci_level}{Confidence level used in \code{type = "stability"}.
Defaults to the level stored in \code{object}.}

\item{theme}{Optional ggplot2 theme object (e.g., \code{ggplot2::theme_bw()}).
If \code{NULL}, \code{ggplot2::theme_minimal()} is used.}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot2} object.
}
\description{
Produces visual summaries for objects returned by \code{\link{brs_bootstrap}}.
}
\details{
For \code{type = "dist"}, \code{"qq"}, and \code{"stability"},
bootstrap draws must be present in \code{attr(object, "boot_draws")},
obtained by fitting with \code{brs_bootstrap(..., keep_draws = TRUE)}.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
boot <- brs_bootstrap(fit, R = 50)
ggplot2::autoplot(boot, type = "ci_forest")
}

}
\seealso{
\code{\link{brs_bootstrap}}, \code{\link{brs}},
  \code{\link{autoplot.brs}}
}
