% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{AIC.brsmm}
\alias{AIC.brsmm}
\title{AIC for brsmm models}
\usage{
\method{AIC}{brsmm}(object, ..., k = 2)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{...}{Currently ignored.}

\item{k}{Numeric penalty per parameter.}
}
\value{
Numeric scalar.
}
\description{
AIC for brsmm models
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
AIC(fit)
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{logLik.brsmm}},
  \code{\link{BIC.brsmm}}, \code{\link{brs_gof}}
}
