% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_sensitivity.R
\name{prior_sensitivity}
\alias{prior_sensitivity}
\alias{print.prior_sensitivity}
\alias{plot.prior_sensitivity}
\title{Prior Sensitivity Analysis}
\usage{
prior_sensitivity(
  model,
  parameters,
  prior_grid,
  comparison_metric = "KL",
  plot = TRUE,
  n_draws = 2000,
  ...
)

\method{print}{prior_sensitivity}(x, ...)

\method{plot}{prior_sensitivity}(x, ...)
}
\arguments{
\item{model}{A fitted Bayesian model (brmsfit, stanfit, or compatible)}

\item{parameters}{Character vector of parameter names to analyze}

\item{prior_grid}{List of prior specifications to compare (named list)}

\item{comparison_metric}{One of "KL", "Wasserstein", or "overlap"}

\item{plot}{Logical. Whether to generate plots (default: TRUE)}

\item{n_draws}{Number of posterior draws to use (default: 2000)}

\item{...}{Additional arguments passed to plotting functions}

\item{x}{Object of class \code{prior_sensitivity} (for print/plot methods).}
}
\value{
An object of class \code{prior_sensitivity} containing:
\item{sensitivity_metrics}{Data frame with sensitivity metrics}
\item{posteriors}{List of posterior distributions for each prior}
\item{comparison_metric}{Metric used for comparison}
\item{parameters}{Parameters analyzed}
\item{model}{The original fitted model}
}
\description{
Conducts comprehensive prior sensitivity analysis to assess how robust
posterior inferences are to alternative prior specifications.
}
\details{
Prior sensitivity analysis assesses how much posterior inferences depend
on the choice of prior distribution. Small sensitivity metrics indicate
that conclusions are robust to prior specification.
}
\examples{
\donttest{
library(brms)
fit <- brm(mpg ~ hp + wt, data = mtcars)

result <- prior_sensitivity(
  model = fit,
  parameters = c("b_hp", "b_wt"),
  prior_grid = list(
    weak = set_prior("normal(0, 10)", class = "b"),
    strong = set_prior("normal(0, 1)", class = "b")
  ),
  comparison_metric = "KL"
)

print(result)
plot(result)
}

}
