% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_performance.R
\name{predictive_performance}
\alias{predictive_performance}
\title{Predictive Performance Evaluation}
\usage{
predictive_performance(
  model,
  newdata = NULL,
  observed_y,
  metrics = "all",
  credible_level = 0.95,
  n_draws = NULL
)
}
\arguments{
\item{model}{A brmsfit object}

\item{newdata}{Optional data frame for out-of-sample predictions.
If NULL, uses model's original data.}

\item{observed_y}{Numeric vector of observed response values.
Must match nrow(newdata) or length(newdata).}

\item{metrics}{Character vector of metrics to compute.
Options: "rmse" (root mean square error), "mae" (mean absolute error),
"coverage" (credible interval coverage), "crps" (continuous ranked prob score),
"all" (default - all metrics)}

\item{credible_level}{Numeric. Credible interval level for coverage (default: 0.95)}

\item{n_draws}{Integer. Number of posterior draws to use (NULL = all)}
}
\value{
A list of class \code{predictive_performance} containing:
\item{point_metrics}{Data frame with RMSE, MAE, and correlation}
\item{interval_metrics}{Data frame with coverage and interval width}
\item{proper_scores}{Data frame with CRPS and log-score}
\item{prediction_summary}{Data frame with mean, lower CI, upper CI for each observation}
\item{metrics_requested}{Character vector of requested metrics}
\item{model_formula}{Formula from the fitted model}
\item{sample_size}{Number of observations}
}
\description{
Comprehensive evaluation of Bayesian model predictive performance using
multiple metrics: RMSE, MAE, Coverage, and proper scoring rules.
}
\details{
Predictive performance metrics evaluate how well posterior predictions align with data:

Point metrics:
\itemize{
\item RMSE: Square root of mean squared prediction error
\item MAE: Mean absolute error
\item Correlation: Pearson correlation of predictions vs observed
}

Interval metrics:
\itemize{
\item Coverage: Proportion of observations within credible interval
\item Width: Average width of credible intervals
}

Proper scoring rules:
\itemize{
\item CRPS: Continuous Ranked Probability Score (lower is better)
Computed using empirical cumulative distribution function
}
}
\examples{
\donttest{
library(brms)

data <- data.frame(y = rnorm(100, mean = 5), x = rnorm(100))
model <- brm(y ~ x, data = data, chains = 1, iter = 1000, refresh = 0)

perf <- predictive_performance(model, observed_y = data$y, metrics = "all")
print(perf)
}

}
