% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_rmap.R
\name{rmap.mle}
\alias{rmap.mle}
\title{Computes the distribution of `g(x)` where `x` is an `mle` object.}
\usage{
\method{rmap}{mle}(x, g, ..., n = 1000L, method = c("mc", "delta"))
}
\arguments{
\item{x}{an `mle` object}

\item{g}{a function}

\item{...}{additional arguments to pass to the `g` function}

\item{n}{number of samples to take to estimate distribution of `g(x)` if
`method == "mc"`.}

\item{method}{method to use to estimate distribution of `g(x)`,
"delta" or "mc".}
}
\value{
An \code{mle} object of class \code{rmap_mle} representing the
  transformed MLE with variance estimated by the specified method.
}
\description{
By the invariance property of the MLE, if `x` is an `mle` object,
then under the right conditions, asymptotically, `g(x)` is normally
distributed,
    g(x) ~ normal(g(point(x)),sigma)
where `sigma` is the variance-covariance of `f(x)`
}
\details{
We provide two different methods for estimating the
variance-covariance of `f(x)`:
    method = "delta" -> delta method
    method = "mc" -> monte carlo method
}
\examples{
# MLE for normal distribution
set.seed(123)
x <- rnorm(100, mean = 5, sd = 2)
n <- length(x)
fit <- mle(
  theta.hat = c(mu = mean(x), var = var(x)),
  sigma = diag(c(var(x)/n, 2*var(x)^2/n)),
  nobs = n
)

# Transform: compute MLE of standard deviation (sqrt of variance)
# Using delta method
g <- function(theta) sqrt(theta[2])
sd_mle <- rmap(fit, g, method = "delta")
params(sd_mle)
se(sd_mle)
}
