% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_tri.R
\name{process_tri}
\alias{process_tri}
\title{Process Triaxial Minute-to-Minute Accelerometer Data}
\usage{
process_tri(counts, steps = NULL, nci_methods = FALSE, start_day = 1,
  start_date = NULL, id = NULL, brevity = 1, hourly_var = "cpm",
  hourly_wearmin = 0, hourly_normalize = FALSE, valid_days = 1,
  valid_wk_days = 0, valid_we_days = 0, int_axis = "vert",
  int_cuts = c(100, 760, 2020, 5999), cpm_nci = FALSE,
  days_distinct = FALSE, nonwear_axis = "vert", nonwear_window = 60,
  nonwear_tol = 0, nonwear_tol_upper = 99, nonwear_nci = FALSE,
  weartime_minimum = 600, weartime_maximum = 1440,
  active_bout_length = 10, active_bout_tol = 0, mvpa_bout_tol_lower = 0,
  vig_bout_tol_lower = 0, active_bout_nci = FALSE, sed_bout_tol = 0,
  sed_bout_tol_maximum = int_cuts[2] - 1, artifact_axis = "vert",
  artifact_thresh = 25000, artifact_action = 1, weekday_weekend = FALSE,
  return_form = "daily")
}
\arguments{
\item{counts}{Integer matrix with three columns of count values, e.g. 
vertical-axis counts, anteroposterior (AP)-axis counts, and 
mediolateral (ML)-axis counts.}

\item{steps}{Integer vector with steps.}

\item{nci_methods}{Logical value for whether to set all arguments so as to 
replicate the data processing methods used in the NCI's SAS programs. More 
specifically: 

\code{valid_days = 4}

\code{valid_wk_days = 0}

\code{valid_we_days = 0}

\code{int_axis = "vert"}

\code{int_cuts = c(100, 760, 2020, 5999)}

\code{cpm_nci = TRUE}

\code{days_distinct = TRUE}

\code{nonwear_axis = "vert"}

\code{nonwear_window = 60}

\code{nonwear_tol = 2}

\code{nonwear_tolupper = 100}

\code{nonwear_nci = TRUE}

\code{weartime_minimum = 600}

\code{weartime_maximum = 1440}

\code{active_bout_length = 10}

\code{active_bout_tol = 2}

\code{mvpa_bout_tol_lower = 0}

\code{vig_bout_tol_lower = 0}

\code{active_bout_nci = TRUE}

\code{sed_bout_tol = 0}

\code{sed_bout_tol_maximum = 759}

\code{artifact_thresh = 32767}

\code{artifact_action = 3}

If \code{TRUE}, you can still specify non-default values for \code{brevity} 
and \code{weekday_weekend}.}

\item{start_day}{Integer value specifying day of week for first day of 
monitoring, with 1 = Sunday, ..., 7 = Satuday.}

\item{start_date}{Date for first day of monitoring, which function can use to 
figure out \code{start_day}.}

\item{id}{Numeric value specifying ID number of participant.}

\item{brevity}{Integer value controlling the number of physical activity 
variables generated. Choices are 1 for basic indicators of physical activity 
volume, 2 for addditional indicators of activity intensities, activity bouts, 
sedentary behavior, and peak activity, and 3 for additional hourly count 
averages.}

\item{hourly_var}{Character string specifying what hourly activity variable 
to record, if \code{brevity = 3}. Choices are "counts_vert", "counts_ap", 
"counts_ml", "counts_sum", "counts_vm", "cpm_vert", "cpm_ap", "cpm_ml", 
"sed_min", "sed_bouted_10min", and "sed_breaks".}

\item{hourly_wearmin}{Integer value specifying minimum number of wear time 
minutes needed during a given hour to record a value for the hourly activity 
variable.}

\item{hourly_normalize}{Logical value for whether to normalize hourly 
activity by number of wear time minutes.}

\item{valid_days}{Integer value specifying minimum number of valid days to 
be considered valid for analysis.}

\item{valid_wk_days}{Integer value specifying minimum number of valid 
weekdays to be considered valid for analysis.}

\item{valid_we_days}{Integer value specifying minimum number of valid weekend 
days to be considered valid for analysis.}

\item{int_axis}{Character string specifying which axis should be used to 
classify intensities. Choices are "vert", "ap", "ml", "sum" (for triaxial 
sum), and "vm (for triaxial vector magnitude).}

\item{int_cuts}{Numeric vector with four cutpoints from which five intensity 
ranges are derived. For example, \code{int_cuts = c(100, 760, 2020, 5999)} 
creates: 0-99 = intensity 1; 100-759 = intensity level 2; 760-2019 = 
intensity 3; 2020-5998 = intensity 4; >= 5999 = intensity 5. Intensities 1-5 
are typically viewed as sedentary, light, lifestyle, moderate, and vigorous.}

\item{cpm_nci}{Logical value for whether to calculate average counts per 
minute by dividing average daily counts by average daily wear time, as 
opposed to taking the average of each day's counts per minute value. Strongly 
recommend leave as \code{FALSE} unless you wish to replicate the NCI's SAS 
programs.}

\item{days_distinct}{Logical value for whether to treat each day of data as 
distinct, as opposed to analyzing the entire monitoring period as one 
continuous segment.}

\item{nonwear_axis}{Character string specifying which axis should be used to 
classify non-wear time. Choices are "vert", "ap", "ml", "sum" (for triaxial 
sum), and "vm" (for triaxial vector magnitude).}

\item{nonwear_window}{Integer value specifying minimum length of a non-wear 
period.}

\item{nonwear_tol}{Integer value specifying tolerance for non-wear algorithm, 
i.e. number of minutes with non-zero counts allowed during a non-wear 
interval.}

\item{nonwear_tol_upper}{Integer value specifying maximum count value for a 
minute with non-zero counts during a non-wear interval.}

\item{nonwear_nci}{Logical value for whether to use non-wear algorithm from 
NCI's SAS programs.}

\item{weartime_minimum}{Integer value specifying minimum number of wear time 
minutes for a day to be considered valid.}

\item{weartime_maximum}{Integer value specifying maximum number of wear time 
minutes for a day to be considered valid. The default is 1440, but you may 
want to use a lower value (e.g. 1200) if participants were instructed to 
remove devices for sleeping, but often did not.}

\item{active_bout_length}{Integer value specifying minimum length of an 
active bout.}

\item{active_bout_tol}{Integer value specifying number of minutes with counts 
outside the required range to allow during an active bout. If non-zero and 
\code{active_bout_nci = FALSE}, specifying non-zero values for 
\code{mvpa_bout_tol_lower} and \code{vig_bout_tol_lower} is highly 
recommended. Otherwise minutes immediately before and after an active bout 
will tend to be classified as part of the bout.}

\item{mvpa_bout_tol_lower}{Integer value specifying lower cut-off for count 
values outside of required intensity range for an MVPA bout.}

\item{vig_bout_tol_lower}{Integer value specifying lower cut-off for count 
values outside of required intensity range for a vigorous bout.}

\item{active_bout_nci}{Logical value for whether to use algorithm from the 
NCI's SAS programs for classifying active bouts.}

\item{sed_bout_tol}{Integer value specifying number of minutes with counts 
outside sedentary range to allow during a sedentary bout.}

\item{sed_bout_tol_maximum}{Integer value specifying upper cut-off for count 
values outside sedentary range during a sedentary bout.}

\item{artifact_axis}{Character string specifying which axis should be used to 
identify artifacts (impossibly high count values). Choices are "vert", "ap", 
"ml", "sum" (for triaxial sum), and "vm" (for triaxial vector magnitude).}

\item{artifact_thresh}{Integer value specifying the smallest count value that 
should be considered an artifact.}

\item{artifact_action}{Integer value controlling method of correcting 
artifacts. Choices are 1 to exclude days with one or more artifacts, 2 to 
lump artifacts into non-wear time, 3 to replace artifacts with the average of 
neighboring count values, and 4 to take no action.}

\item{weekday_weekend}{Logical value for whether to calculate averages for 
weekdays and weekend days separately (in addition to all valid days).}

\item{return_form}{Character string controlling how variables are returned. 
Choices are "daily" for per-day summaries, "averages" for averages across 
all valid days, and "both" for a list containing both.}
}
\value{
Numeric matrix or list of two numeric matrices, depending on 
\code{return_form}.
}
\description{
Calculates a variety of physical activity variables based on triaxial 
minute-to-minute accelerometer count values for individual participants. 
Assumes first 1440 minutes are day 1, next 1440 are day 2, and so on. If 
final day has less than 1440 minutes, it is excluded. A data dictionary for 
the variables created is available here: 
\url{https://github.com/vandomed/accelerometry/blob/master/process_tri_dictionary.csv}.
}
\examples{
# Note that the 'tridata' dataset contains 7 days of fake triaxial 
# accelerometer data

# Process data using default parameters and request per-day variables
accel.days <- process_tri(
  counts = tridata, 
  return_form = "daily"
)

# Repeat, but request averages across all valid days
accel.averages <- process_tri(
  counts = tridata,
  return_form = "averages"
)

# Create per-day summary again, but with many more variables
accel.days2 <- process_tri(
  counts = tridata, 
  brevity = 2,
  return_form = "daily"
)
names(accel.days2)


}
\references{
National Cancer Institute. Risk factor monitoring and methods: SAS programs 
for analyzing NHANES 2003-2004 accelerometer data. Available at: 
\url{http://riskfactor.cancer.gov/tools/nhanes_pam}. Accessed Aug. 19, 2018.
}
