% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_meanplot.R
\name{general_meanplot}
\alias{general_meanplot}
\title{Generate a Mean Concentration Plot for ADNCA Dataset}
\usage{
general_meanplot(
  data,
  selected_studyids,
  selected_analytes,
  selected_pcspecs,
  selected_cycles,
  id_variable = "DOSEA",
  groupby_var = c("STUDYID", "PARAM", "PCSPEC", "ATPTREF"),
  plot_ylog = FALSE,
  plot_sd_min = FALSE,
  plot_sd_max = FALSE,
  plot_ci = FALSE
)
}
\arguments{
\item{data}{A data frame containing the ADNCA dataset.}

\item{selected_studyids}{A character vector of selected study IDs to be included in the plot.}

\item{selected_analytes}{A character vector of selected analytes to be included in the plot.}

\item{selected_pcspecs}{A character vector of selected matrices to be included in the plot.}

\item{selected_cycles}{A character vector or numeric vector of selected cycles to be
included in the plot.}

\item{id_variable}{A character string specifying the variable by which to color the lines
in the plot. Default is "DOSEA".}

\item{groupby_var}{A character string specifying the variable by which to group the data.}

\item{plot_ylog}{A logical value indicating whether to use a logarithmic scale for
the y-axis. Default is FALSE.}

\item{plot_sd_min}{A logical value to add a SD error bar below the mean. Default is FALSE.}

\item{plot_sd_max}{A logical value to add a SD error bar above the mean. Default is FALSE.}

\item{plot_ci}{A logical value indicating whether to include confidence interval 95\%
ribbon. Default is FALSE.}
}
\value{
A ggplot object representing the mean concentration plot.
}
\description{
This function generates a mean concentration plot for an ADNCA dataset based on user-selected
study IDs, analytes, and cycles. The plot can be customized to display data on a linear or
logarithmic scale and can optionally include standard deviation error bars.
}
