
test_that("example raster files are loaded correctly", {

  library(terra)

  albedo_path <- system.file("extdata", "albedo_mini.tif", package = "Ts")
  ndvi_path   <- system.file("extdata", "ndvi_mini.tif", package = "Ts")
  Ta_path     <- system.file("extdata", "Ta_mini.tif", package = "Ts")

  # Check if the files exist
  expect_true(file.exists(albedo_path))
  expect_true(file.exists(ndvi_path))
  expect_true(file.exists(Ta_path))

  # Load rasters
  albedo <- rast(albedo_path)
  ndvi   <- rast(ndvi_path)
  Ta     <- rast(Ta_path)

  # Check classes
  expect_s4_class(albedo, "SpatRaster")
  expect_s4_class(ndvi, "SpatRaster")
  expect_s4_class(Ta, "SpatRaster")
})
