% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gonjo.R
\docType{data}
\name{Gonjo}
\alias{Gonjo}
\title{AMS data of the Gonjo Basin}
\format{
A list with entry \code{datatable} containing one row per specimen and entry \code{matrices} containing the AMS tensor (i.e. symmetric matrix) for each specimen.
The \code{datatable} entry has 542 rows and 25 variables:
\itemize{
\item \code{Name}: character — Specimen name
\item \verb{really depth}: double — Depth of specimen (in meters)
\item \code{Field}: double — Unsure — \insertCite{li2020an;textual}{TFORGE} say they applied a 300 A/m magnetic field
\item \code{Freq.}: double — Frequency of oscillation of the applied magnetic field
\item \code{Km}: double — Mean magnetic susceptibility
\item \code{L}: double — Lineation (\eqn{\lambda_1 / \lambda_2})
\item \code{F}: double — Foliation (\eqn{\lambda_2 / \lambda_3})
\item \code{P}: double — Uncorrected degree of anisotropy (\eqn{\lambda_1 / \lambda_3} )
\item \code{Pj}: double — Corrected degree of anisotropy
\item \code{T}: double — Shape factor
\item \code{U}: double — \emph{Unsure}
\item \code{Q}: double — \emph{Unsure}
\item \code{E}: double — \emph{Unsure}
\item \code{K1decI} and \code{K1incI}: doubles — In-situ direction of first eigenvector
\item \code{K2decI} and \code{K2incI}: doubles — In-situ direction of second eigenvector
\item \code{K3decI} and \code{K3incI}: doubles — In-situ direction of third eigenvector
\item \code{K1decT} and \code{K1incT}: doubles — Tilt-corrected direction of first eigenvector
\item \code{K2decT} and \code{K2incT}: doubles — Tilt-corrected of second eigenvector
\item \code{K3decT} and \code{K3incT}: doubles — Tilt-corrected of third eigenvector
}
}
\source{
\doi{10.5281/zenodo.3666760}
}
\usage{
Gonjo
}
\description{
This is the anisotropy of magnetic susceptibility (AMS) data from a 3km thick section of redbeds in the Gonjo Basin in eastern Tibet that was analysed by \insertCite{li2020an;textual}{TFORGE}.
}
\details{
The AMS matrices were calculated using the in-situ directions by Dr. Janice Scealy.

The data from \doi{10.5281/zenodo.3666760} has a \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International} license.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
