% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimEUCartelLaw.r
\name{NoRglPlot}
\alias{NoRglPlot}
\title{Visualize results of simulation of legal exemption system}
\usage{
NoRglPlot(res, xvar = "rA", yvar = "rM", zvar = "c", xf = 1, yf = 1,
  zf = 1, pch = 16, phi = 20, theta = -30, d = 2)
}
\arguments{
\item{res}{dataframe containing results of simulation using \code{LEgame}.}

\item{xvar}{character scalar containing variable for the x-axis.
Defaults to \code{"rA"}, the simulated illegal gain.}

\item{yvar}{character scalar containing variable for the y-axis.
Defaults to \code{"rM"}, the simulated fine.}

\item{zvar}{character scalar containing variable for the z-axis.
Defaults to \code{"c"}, the complicance level.}

\item{xf}{numeric scalar containing scaling constant for the x-axis. Defaults
to \code{1}.}

\item{yf}{numeric scalar containing scaling constant for the y-axis. Defaults
to \code{1}.}

\item{zf}{numeric scalar containing scaling constant for the z-axis. Defaults
to \code{1}.}

\item{pch}{numeric or character scalar containing the plot character used 
for the individual points. Defaults to \code{16}.}

\item{phi}{numeric scalar containing the phi angle (colatitude)
for the perspective in degrees. Defaults to \code{20}.}

\item{theta}{numeric scalar containing the theta angle (azimuthal direction)
for the perspective in degrees. Defaults to \code{-30}.}

\item{d}{numeric scalar for the strenth of the perspective effect. 
Defaults to \code{2}.}
}
\value{
Nothing useful, function called for its side effects.
}
\description{
\code{NoRglPlot} visualizes the results of the simulation of the legal 
exemption system using 3D-projections and corresponding 3D-plots.
}
\details{
\code{NoRglPlot} visualizes the results of the simulation of the legal 
exemption system using 3D-projections and corresponding plots without 
using \code{rgl}/\code{GL}.
}
\examples{
\donttest{
Par <- list(Phi=c(0.1,0.5), Rho=c(0.5,0.9), Ksi=c(0.05,0.3), Chi=c(0.1,0.4),
            M=c(0.2,1.2), G=c(0.05,0.2), A=c(0.1,0.3))
NoRglPlot(LEgame(params=Par, m=10000))
}
}
