% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmix.R
\name{rmix}
\alias{rmix}
\title{Draw from a Gaussian Mixture Model}
\usage{
rmix(n, pi, mu, sigma, seed_number)
}
\arguments{
\item{n}{Integer. Number of observations to generate.}

\item{pi}{Numeric vector of length \eqn{g}. Mixing proportions (must sum to 1).}

\item{mu}{Numeric matrix \eqn{p \times g}. Column \eqn{j} is the mean for component \eqn{j}.}

\item{sigma}{Either a numeric matrix \eqn{p \times p} (shared covariance),
or a numeric array \eqn{p \times p \times g} (component-specific covariances).}

\item{seed_number}{Integer. Seed for reproducibility.}
}
\value{
A list with:
\item{Y}{Numeric matrix \eqn{n \times p} of generated features.}
\item{Z}{Numeric matrix \eqn{n \times g} of one-hot component indicators.}
\item{clust}{Integer vector \eqn{n}, the component labels in \code{1:g}.}
}
\description{
Generate i.i.d. samples from a finite Gaussian mixture with either a shared
covariance matrix or component-specific covariance matrices.
}
\examples{
  set.seed(1)
  g  <- 2; p <- 2
  pi <- c(0.5, 0.5)
  mu <- cbind(c(1,0), c(-1,0))
  Sigma <- diag(p)
  out <- rmix(500, pi, mu, Sigma, seed_number = 123)
  str(out)

}
