% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SRscore_distr.R
\name{plot_SRscore_distr}
\alias{plot_SRscore_distr}
\title{Plot the Distribution of SRscore Values}
\usage{
plot_SRscore_distr(srscore, log = FALSE)
}
\arguments{
\item{srscore}{A data.frame containing at least one column named \code{score},
which represents the SRscore values to be plotted.}

\item{log}{Logical (default: \code{FALSE}).
If \code{TRUE}, the y-axis of the barplot is shown in logarithmic scale (\code{log = "y"}).}
}
\value{
This function returns \code{NULL} invisibly and produces a barplot as a side effect.
}
\description{
This function visualizes the distribution of SRscore values using a barplot.
Values equal to 0 are excluded from the plot by design because they typically represent
genes without detectable stress response activity.
}
\details{
The function provides both a linear-scale plot and a log-scale version, which is
particularly useful when the frequency of SRscore values spans a wide range.

The function performs the following steps:
\itemize{
\item Validates that \code{srscore} is a data.frame and contains a \code{score} column.
\item Removes SRscore values equal to 0.
\item Produces a barplot of the frequency of SRscore values.
\item Optionally draws the plot on a logarithmic y-axis.
}
}
\examples{
# Example SRscore data
df <- data.frame(score = c(-5, -3, -3, 1, 2, 2, 2, 4, 5, 5, 0))

# Linear-scale plot
plot_SRscore_distr(df)

# Log-scale plot
plot_SRscore_distr(df, log = TRUE)

}
