test_that("end-to-end: mixed-type data works", {
  skip_if_not_installed("mlbench")

  data(Sonar, package = "mlbench")

  fit <- random_gaussian_nb(
    Sonar,
    response = "Class",
    n_iter = 10,
    feature_fraction = 0.3,
    cores = 1
  )

  expect_s3_class(fit, "random_gaussian_nb")

  preds <- predict(fit)
  probs <- predict(fit, type = "prob")

  expect_length(preds, nrow(Sonar))
  expect_true(is.factor(preds))
  expect_true(is.data.frame(probs))
  expect_equal(nrow(probs), nrow(Sonar))
})
